/**
 * Domain class that stores various application configuration (settings) in the database.
 * Use AppConfigService to interact with the instances.
 */
class AppConfig {
    String name
    String value
    String description = ''

    static constraints = {
        name(maxSize:50,unique:true,blank:false)
        description(maxSize:100)
        value(maxSize:50,blank:false)
    }

    String toString() {
        "${this.name} = ${this.value}"
    }
}
