import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssetTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ assetTypeInstanceList: AssetType.list( params ), assetTypeInstanceTotal: AssetType.count() ]
    }

    def show = {
        def assetTypeInstance = AssetType.get( params.id )

        if(!assetTypeInstance) {
            flash.message = "AssetType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ assetTypeInstance : assetTypeInstance ] }
    }

    def delete = {
        def assetTypeInstance = AssetType.get( params.id )
        if(assetTypeInstance) {
            try {
                assetTypeInstance.delete(flush:true)
                flash.message = "AssetType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AssetType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AssetType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def assetTypeInstance = AssetType.get( params.id )

        if(!assetTypeInstance) {
            flash.message = "AssetType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ assetTypeInstance : assetTypeInstance ]
        }
    }

    def update = {
        def assetTypeInstance = AssetType.get( params.id )
        if(assetTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assetTypeInstance.version > version) {
                    
                    assetTypeInstance.errors.rejectValue("version", "assetType.optimistic.locking.failure", "Another user has updated this AssetType while you were editing.")
                    render(view:'edit',model:[assetTypeInstance:assetTypeInstance])
                    return
                }
            }
            assetTypeInstance.properties = params
            if(!assetTypeInstance.hasErrors() && assetTypeInstance.save(flush: true)) {
                flash.message = "AssetType ${params.id} updated"
                redirect(action:show,id:assetTypeInstance.id)
            }
            else {
                render(view:'edit',model:[assetTypeInstance:assetTypeInstance])
            }
        }
        else {
            flash.message = "AssetType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def assetTypeInstance = new AssetType()
        assetTypeInstance.properties = params
        return ['assetTypeInstance':assetTypeInstance]
    }

    def save = {
        def assetTypeInstance = new AssetType(params)
        if(!assetTypeInstance.hasErrors() && assetTypeInstance.save(flush: true)) {
            flash.message = "AssetType ${assetTypeInstance.id} created"
            redirect(action:show,id:assetTypeInstance.id)
        }
        else {
            render(view:'create',model:[assetTypeInstance:assetTypeInstance])
        }
    }
}
