import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class InventoryLocationController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ inventoryLocationInstanceList: InventoryLocation.list( params ), inventoryLocationInstanceTotal: InventoryLocation.count() ]
    }

    def show = {
        def inventoryLocationInstance = InventoryLocation.get( params.id )

        if(!inventoryLocationInstance) {
            flash.message = "InventoryLocation not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ inventoryLocationInstance : inventoryLocationInstance ] }
    }

    def delete = {
        def inventoryLocationInstance = InventoryLocation.get( params.id )
        if(inventoryLocationInstance) {
            try {
                inventoryLocationInstance.delete(flush:true)
                flash.message = "InventoryLocation ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "InventoryLocation ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "InventoryLocation not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def inventoryLocationInstance = InventoryLocation.get( params.id )

        if(!inventoryLocationInstance) {
            flash.message = "InventoryLocation not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ inventoryLocationInstance : inventoryLocationInstance ]
        }
    }

    def update = {
        def inventoryLocationInstance = InventoryLocation.get( params.id )
        if(inventoryLocationInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(inventoryLocationInstance.version > version) {
                    
                    inventoryLocationInstance.errors.rejectValue("version", "inventoryLocation.optimistic.locking.failure", "Another user has updated this InventoryLocation while you were editing.")
                    render(view:'edit',model:[inventoryLocationInstance:inventoryLocationInstance])
                    return
                }
            }
            inventoryLocationInstance.properties = params
            if(!inventoryLocationInstance.hasErrors() && inventoryLocationInstance.save(flush: true)) {
                flash.message = "InventoryLocation ${params.id} updated"
                redirect(action:show,id:inventoryLocationInstance.id)
            }
            else {
                render(view:'edit',model:[inventoryLocationInstance:inventoryLocationInstance])
            }
        }
        else {
            flash.message = "InventoryLocation not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def inventoryLocationInstance = new InventoryLocation()
        inventoryLocationInstance.properties = params
        return ['inventoryLocationInstance':inventoryLocationInstance]
    }

    def save = {
        def inventoryLocationInstance = new InventoryLocation(params)
        if(!inventoryLocationInstance.hasErrors() && inventoryLocationInstance.save(flush: true)) {
            flash.message = "InventoryLocation ${inventoryLocationInstance.id} created"
            redirect(action:show,id:inventoryLocationInstance.id)
        }
        else {
            render(view:'create',model:[inventoryLocationInstance:inventoryLocationInstance])
        }
    }
}
