

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit SubAssembly</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="list" action="list">SubAssembly List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New SubAssembly</g:link></span>
        </div>
        <div class="body">
            <h1>Edit SubAssembly</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${subAssemblyInstance}">
            <div class="errors">
                <g:renderErrors bean="${subAssemblyInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${subAssemblyInstance?.id}" />
                <input type="hidden" name="version" value="${subAssemblyInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assembly">Assembly:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:subAssemblyInstance,field:'assembly','errors')}">
                                    <g:select optionKey="id" from="${Assembly.list()}" name="assembly.id" value="${subAssemblyInstance?.assembly?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="componentItems">Component Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:subAssemblyInstance,field:'componentItems','errors')}">
                                    
<ul>
<g:each var="c" in="${subAssemblyInstance?.componentItems?}">
    <li><g:link controller="componentItem" action="show" id="${c.id}">${c?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="componentItem" params="['subAssembly.id':subAssemblyInstance?.id]" action="create">Add ComponentItem</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:subAssemblyInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:subAssemblyInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:subAssemblyInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${subAssemblyInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenanceActions">Maintenance Actions:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:subAssemblyInstance,field:'maintenanceActions','errors')}">
                                    
<ul>
<g:each var="m" in="${subAssemblyInstance?.maintenanceActions?}">
    <li><g:link controller="maintenanceAction" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="maintenanceAction" params="['subAssembly.id':subAssemblyInstance?.id]" action="create">Add MaintenanceAction</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:subAssemblyInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:subAssemblyInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
