class Asset {

    Section section

    String name
    String description = ""
    boolean isActive = true

    static hasMany = [assetSubItems: AssetSubItem,
                                    maintenanceActions: MaintenanceAction,
                                    assetExtendedAttributes: AssetExtendedAttribute]

    static belongsTo = [Section]

    static constraints = {
        name(maxSize:50, unique:true, blank:false)
        description(maxSize:100)
        isActive()
        section()
    }

    String toString() {
        "${this.name}"
    }
}

