import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskGroupController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskGroupInstanceList: TaskGroup.list( params ), taskGroupInstanceTotal: TaskGroup.count() ]
    }

    def show = {
        def taskGroupInstance = TaskGroup.get( params.id )

        if(!taskGroupInstance) {
            flash.message = "TaskGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskGroupInstance : taskGroupInstance ] }
    }

    def delete = {
        def taskGroupInstance = TaskGroup.get( params.id )
        if(taskGroupInstance) {
            try {
                taskGroupInstance.delete(flush:true)
                flash.message = "TaskGroup ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskGroup ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskGroupInstance = TaskGroup.get( params.id )

        if(!taskGroupInstance) {
            flash.message = "TaskGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskGroupInstance : taskGroupInstance ]
        }
    }

    def update = {
        def taskGroupInstance = TaskGroup.get( params.id )
        if(taskGroupInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskGroupInstance.version > version) {
                    
                    taskGroupInstance.errors.rejectValue("version", "taskGroup.optimistic.locking.failure", "Another user has updated this TaskGroup while you were editing.")
                    render(view:'edit',model:[taskGroupInstance:taskGroupInstance])
                    return
                }
            }
            taskGroupInstance.properties = params
            if(!taskGroupInstance.hasErrors() && taskGroupInstance.save(flush: true)) {
                flash.message = "TaskGroup ${params.id} updated"
                redirect(action:show,id:taskGroupInstance.id)
            }
            else {
                render(view:'edit',model:[taskGroupInstance:taskGroupInstance])
            }
        }
        else {
            flash.message = "TaskGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def taskGroupInstance = new TaskGroup()
        taskGroupInstance.properties = params
        return ['taskGroupInstance':taskGroupInstance]
    }

    def save = {
        def taskGroupInstance = new TaskGroup(params)
        if(!taskGroupInstance.hasErrors() && taskGroupInstance.save(flush: true)) {
            flash.message = "TaskGroup ${taskGroupInstance.id} created"
            redirect(action:show,id:taskGroupInstance.id)
        }
        else {
            render(view:'create',model:[taskGroupInstance:taskGroupInstance])
        }
    }
}
