/**
* Asset Tree tags.
* Specific to gnuMims hence the namespace.
*/
class AssetTreeTagLib {
    static namespace = 'gnuMims'

    def resources = { attrs ->
        ///@todo: should include our javascript and do setup here.
    }

    def assetTreeButton = {
        def mkp = new groovy.xml.MarkupBuilder(out) //this line will be unnecessary in versions of Grails after version 1.2

        mkp.div(class: "tree_button") {
            a(href: showPane()) {
                img(src: treeRootImg())
            }
        }
    } // mkp

    def assetTree = { attrs ->

        def sites = Site.list()

        def visibleBranches = session.assetTreeVisibleBranches ? session.assetTreeVisibleBranches.tokenize(',') : []

        def branchStyle = { branchId ->
            if(visibleBranches.contains(branchId))
                ''
            else
                'display:none;'
        }

        def branchImg = { branchId ->
            if(visibleBranches.contains(branchId))
                bulletTreeMinusImg()
            else
                bulletTreePlusImg()
        }

        def divIdCount = 0
        def divId = ''
        def nextDivId = {
            divIdCount++
            divId = 'assetTreeBranch'+divIdCount
        }

        def mkp = new groovy.xml.MarkupBuilder(out) //this line will be unnecessary in versions of Grails after version 1.2

        // Offer a site create link if no sites are found.
        if(!sites) {
            mkp.div(class: 'overlayPane', id: 'assetTreePane', style: 'display:none;') {
                div(class: 'tree', id: 'assetTreeTable') {
                    table() {
                        tr() {
                            td( valign: 'top', class: 'value') {
                                ul() {
                                    img(src: treeRootImg(), alt: 'TreeRoot')
                                    li() {
                                        a(href: siteCreateLink()) {
                                            img(src: addImg(), alt: 'Add', title: 'Add Site')
                                        }
                                    } // li
                                } // ul
                            } // td
                        } // tr
                    } // table
                } // div

                div( class: 'buttons') {
                    span(class: 'button') {
                        input( type: 'button', value: 'Close', onclick: hideAssetTreePane() )
                    }
                } // button div
            } // mkp
            return
        } // if(!sites)


        /// @todo: use a loop for the subItem levels.
        mkp.div(class: 'overlayPane', id: 'assetTreePane', style: 'display:none;') {
            div(class: 'tree', id: 'assetTreeTable') {
                table() {
                    tr() {
                        td( valign: 'top', class: 'value') {
                            ul() {
                                img(src: treeRootImg(), alt: 'TreeRoot')
                                for(site in sites.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                    li() {
                                        if(site.sections) {
                                            a(href: toggleBranch(nextDivId()) ) {
                                                img( src: branchImg(divId), id: divId+'img' )
                                            }
                                        }
                                        else
                                            img(src: dashImg())
                                        a( href: siteShowLink(site.id), onclick: hideAssetTreePane() ) {
                                            yieldUnescaped( site.encodeAsHTML() )
                                        }
                                        a(href: sectionCreateLink(site.id), onclick: hideAssetTreePane()) {
                                            img(src: addImg(), alt: 'Add', title: 'Add Section')
                                        }
                                    }
                                    if(site.sections) {
                                        div( id: divId, style: branchStyle(divId) ) {
                                            ul() {
                                                for(section in site.sections.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                    li() {
                                                        if(section.assets) {
                                                            a( href: toggleBranch(nextDivId()) ) {
                                                                img(src: branchImg(divId), id: divId+'img' )
                                                            }
                                                        }
                                                        else
                                                            img(src: dashImg())
                                                        a( href: sectionShowLink(section.id), onclick: hideAssetTreePane() ) {
                                                            yieldUnescaped( section.encodeAsHTML() )
                                                        }
                                                        a(href: assetCreateLink(section.id), onclick: hideAssetTreePane()) {
                                                            img(src: addImg(), alt: 'Add', title: 'Add Asset')
                                                        }
                                                    }

                                                    if(section.assets) {
                                                        div( id: divId, style: branchStyle(divId) ) {
                                                            ul() {
                                                                for(asset in section.assets.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                    li() {
                                                                        if(asset.assetSubItems) {
                                                                            a( href: toggleBranch(nextDivId()) ) {
                                                                                img(src: branchImg(divId), id: divId+'img' )
                                                                            }
                                                                        }
                                                                        else
                                                                            img(src: dashImg())
                                                                        a( href: assetShowLink(asset.id), onclick: hideAssetTreePane() ) {
                                                                            yieldUnescaped( asset.encodeAsHTML() )
                                                                        }
                                                                        a(href: assetSubItemCreateLink(asset.id), onclick: hideAssetTreePane()) {
                                                                            img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                                                                        }
                                                                        a(href: assetCopyLink(asset.id), onclick: hideAssetTreePane()) {
                                                                            img(src: copyImg(), alt: 'Add', title: 'Copy Asset')
                                                                        }
                                                                    } // li

                                                                    if(asset.assetSubItems) {
                                                                        div( id: divId, style: branchStyle(divId) ) {
                                                                            ul() {
                                                                                for(assetSubItemL1 in asset.assetSubItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                                    li() {
                                                                                        if(assetSubItemL1.subItems) {
                                                                                            a( href: toggleBranch(nextDivId()) ) {
                                                                                                img(src: branchImg(divId), id: divId+'img' )
                                                                                            }
                                                                                        }
                                                                                        else
                                                                                            img(src: dashImg())
                                                                                        a( href: assetSubItemShowLink(assetSubItemL1.id), onclick: hideAssetTreePane() ) {
                                                                                            yieldUnescaped( assetSubItemL1.encodeAsHTML() )
                                                                                        }
                                                                                        a(href: assetSubItemCreateWithParentLink(assetSubItemL1.id), onclick: hideAssetTreePane()) {
                                                                                            img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                                                                                        }
                                                                                    } // li

                                                                                    if(assetSubItemL1.subItems) {
                                                                                        div( id: divId, style: branchStyle(divId) ) {
                                                                                            ul() {
                                                                                                for(assetSubItemL2 in assetSubItemL1.subItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                                                    li() {
                                                                                                        if(assetSubItemL2.subItems) {
                                                                                                            a( href: toggleBranch(nextDivId()) ) {
                                                                                                                img( src: branchImg(divId), id: divId+'img' )
                                                                                                            }
                                                                                                        }
                                                                                                        else
                                                                                                            img(src: dashImg())
                                                                                                        a( href: assetSubItemShowLink(assetSubItemL2.id), onclick: hideAssetTreePane() ) {
                                                                                                            yieldUnescaped( assetSubItemL2.encodeAsHTML() )
                                                                                                        }
                                                                                                        a(href: assetSubItemCreateWithParentLink(assetSubItemL2.id), onclick: hideAssetTreePane()) {
                                                                                                            img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                                                                                                        }
                                                                                                    } // li

                                                                                                    if(assetSubItemL2.subItems) {
                                                                                                        div( id: divId, style: branchStyle(divId) ) {
                                                                                                            ul() {
                                                                                                                for(assetSubItemL3 in assetSubItemL2.subItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                                                                    li() {
                                                                                                                        if(assetSubItemL3.subItems) {
                                                                                                                            a( href: toggleBranch(nextDivId()) ) {
                                                                                                                                img( src: branchImg(divId), id: divId+'img' )
                                                                                                                            }
                                                                                                                        }
                                                                                                                        else
                                                                                                                            img(src: dashImg())
                                                                                                                        a( href: assetSubItemShowLink(assetSubItemL3.id), onclick: hideAssetTreePane() ) {
                                                                                                                            yieldUnescaped( assetSubItemL3.encodeAsHTML() )
                                                                                                                        }
                                                                                                                        a(href: assetSubItemCreateWithParentLink(assetSubItemL3.id), onclick: hideAssetTreePane()) {
                                                                                                                            img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                                                                                                                        }
                                                                                                                    } // li

                                                                                                                    if(assetSubItemL3.subItems) {
                                                                                                                        div( id: divId, style: branchStyle(divId) ) {
                                                                                                                            ul() {
                                                                                                                                for(assetSubItemL4 in assetSubItemL3.subItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                                                                                    li() {
                //                                                                                                                         if(assetSubItemL4.subItems) {
                //                                                                                                                             a( href: toggleBranch(nextDivId()) ) {
                //                                                                                                                                 img( src: branchImg(divId), id: divId+'img' )
                //                                                                                                                             }
                //                                                                                                                         }
                //                                                                                                                         else
                                                                                                                                        img(src: dashImg())
                                                                                                                                        a( href: assetSubItemShowLink(assetSubItemL4.id), onclick: hideAssetTreePane() ) {
                                                                                                                                            yieldUnescaped( assetSubItemL4.encodeAsHTML() )
                                                                                                                                        }
                //                                                                                                                         a(href: assetSubItemCreateWithParentLink(assetSubItemL4.id), onclick: hideAssetTreePane()) {
                //                                                                                                                             img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                //                                                                                                                         }
                                                                                                                                    } // li

                                                                                                                                } // assetSubItemL4
                                                                                                                            } // ul
                                                                                                                        } // div
                                                                                                                    } // if(assetSubItemL3.subItems)


                                                                                                                } // assetSubItemL3
                                                                                                            } // ul
                                                                                                        } // div
                                                                                                    } // if(assetSubItemL2.subItems)

                                                                                                } // assetSubItemL2
                                                                                            } // ul
                                                                                        } // div
                                                                                    } // if(assetSubItemL1.subItems)

                                                                                } // assetSubItemL1
                                                                            } // ul
                                                                        } // div
                                                                    } // if(asset.assetSubItems)

                                                                } // assets
                                                            } // ul
                                                        } // div
                                                    } // if(section.assets)

                                                } //sections
                                            } // ul
                                        } // div
                                    } // if(site.sections) 
                                } // sites
                            } // ul
                        } // td
                    } // tr
                } // table
            } // div

            div( class: 'buttons') {
                span(class: 'button') {
                    input( type: 'button', value: 'Close', onclick: hideAssetTreePane() )
                }
            }

        } // mkp

    } // assetTree


    /** Imgs */

    def treeRootImg() {
        resource(dir:'images/skin',file:'chart_organisation.png').toString()
    }
    def addImg() {
        resource(dir:'images/skin',file:'database_add.png').toString()
    }
    def copyImg() {
        resource(dir:'images/skin',file:'page_copy.png').toString()
    }
    def bulletTreePlusImg() {
        resource(dir:'images/skin',file:'bullet_tree_plus.png').toString()
    }
    // actually set in javascript function.
    def bulletTreeMinusImg() {
        resource(dir:'images/skin',file:'bullet_tree_minus.png').toString()
    }
    def dashImg() {
        resource(dir:'images/skin',file:'hline_short.png').toString()
    }

    /** js calls */

    def showPane() {
       'javascript: showDiv(\"assetTreePane\");'
    }

    def hideAssetTreePane() {
        def saveUrl = createLink(controller: 'appCore', action: 'saveAssetTreeStatus').toString()
        'return hideAssetTreePane(\"assetTreePane\", \"assetTreeTable' + '\", \"' + saveUrl + '\");'
    }

    def toggleBranch(divId) {
        /// @todo: toggleBranch is in overlayPane.js and should be moved to tree.js
       'javascript: toggleBranch(\"' + divId + '\", \"' + divId + 'img' +'\", \"' + bulletTreeMinusImg() +'\", \"' + bulletTreePlusImg() + '\");'
    }

    /** Links */

    def siteCreateLink() {
        createLink(controller: 'siteDetailed', action: 'create').toString()
    }
    def siteShowLink(id) {
        createLink(controller: 'siteDetailed', action: 'show', params: ['id': id] ).toString()
    }

    def siteEditLink(id) {
        createLink(controller: 'siteDetailed', action: 'edit', params: ['id': id] ).toString()
    }

    def sectionCreateLink(siteId) {
        createLink(controller: 'sectionDetailed', action: 'create', params: ['site.id': siteId] ).toString()
    }

    def sectionShowLink(id) {
        createLink(controller: 'sectionDetailed', action: 'show', params: ['id': id] ).toString()
    }

    def sectionEditLink(id) {
        createLink(controller: 'sectionDetailed', action: 'edit', params: ['id': id] ).toString()
    }

    def assetCreateLink(sectionId) {
        createLink(controller: 'assetDetailed', action: 'create', params: ['section.id': sectionId] ).toString()
    }

    def assetShowLink(id) {
        createLink(controller: 'assetDetailed', action: 'show', id: id ).toString()
    }

    def assetEditLink(id) {
        createLink(controller: 'assetDetailed', action: 'edit', id: id ).toString()
    }

    def assetCopyLink(id) {
        createLink(controller: 'assetDetailed', action: 'copy', params: ['assetToCopy.id': id] ).toString()
    }

    def assetSubItemCreateLink(assetId) {
        createLink(controller: 'assetSubItemDetailed', action: 'create', params: ['asset.id': assetId] ).toString()
    }

    def assetSubItemCreateWithParentLink(parentItemId) {
        createLink(controller: 'assetSubItemDetailed', action: 'create', params: ['parentItem.id': parentItemId] ).toString()
    }

    def assetSubItemShowLink(id) {
        createLink(controller: 'assetSubItemDetailed', action: 'show', params: ['id': id] ).toString()
    }

    def assetSubItemEditLink(id) {
        createLink(controller: 'assetSubItemDetailed', action: 'edit', params: ['id': id] ).toString()
    }

} // end class