import org.codehaus.groovy.grails.commons.*

/**
* Provides a quartz job that reviews and generates all recurring tasks.
* The quartz scheduler is restarted if this file is edited so startDelay will then delay again.
* The execute method is called once every repeatInterval (in milliseconds).
* With concurrent=false the repeat interval starts counting after the previous job completes.
* Apparently we need a hibernate session otherwise we get a LazyInitializationException, default is true but we specify it to be sure.
*/
class TaskRecurringScheduleJob {

    def taskRecurringScheduleService

    def concurrent = false
    def sessionRequired = true

    static triggers = {
        simple name: "GenerateAll",
                    startDelay: 60000,
                    repeatInterval: ConfigurationHolder.config.taskRecurringScheduleJob.repeatInterval*1000
    }

    def execute() {

        // Some information can be accessed if we run with "def execute(context) ".
        // For more info see: http://quartz.sourceforge.net/javadoc/org/quartz/JobExecutionContext.html
        // log.debug context.getTrigger()
        // log.debug context.getPreviousFireTime()
        // log.debug context.getFireTime()

        // We do everything via services, quartz just sets up and fires off the thread.
        taskRecurringScheduleService.generateAll()
    }
}
