<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search</title>
        <nav:resources override="true"/>
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>

        <div class="body">
            <g:if test="${flash.message}">
                <div class="message">${flash.message}</div>
            </g:if>
            <g:if test="${params.message}">
                <div class="message">${params.message}</div>
            </g:if>
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>

            <div class="paginateButtons">
                <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                Results:${taskInstanceTotal}
            </div>

            <div class="list">
                <table>
                    <thead>
                        <tr>

                            <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                            <g:sortableColumn property="targetStartDate" title="Target Start Date" params="${filterParams}" />

                            <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                            <g:sortableColumn  property="leadPerson" title="Lead Person" params="${filterParams}" />

                            <g:sortableColumn  property="taskPriority" title="Task Priority" params="${filterParams}" />

                            <g:sortableColumn  property="taskStatus" title="Task Status" params="${filterParams}" />

                            <th></th>

                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${taskInstanceList}" status="i" var="taskInstance">
                    <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'/>

                            <td>${fieldValue(bean:taskInstance, field:'id')}</td>

                            <td><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/></td>

                            <td>${fieldValue(bean:taskInstance, field:'description')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'leadPerson')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'taskPriority')}</td>

                            <td>${fieldValue(bean:taskInstance, field:'taskStatus')}</td>

                            <td>
                                <g:link action="show" id="${taskInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                </g:link>
                            </td>

                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${taskInstanceTotal}" params="${filterParams}" />
            </div>
            <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
        </div> <!-- end body  -->

        <!-- Start Search Pane -->
        <div class="overlayPane" id="searchPane" style="display:none;">
            <h2>Quick Search</h2>
            <g:form method="post" id="searchForm" name="searchForm" >
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Budget:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="taskDetailed"
                                                action="budget"
                                                params="[quickSearch: 'budgetPlanned']">
                                                Planned Tasks
                                </g:link>
                                <br />
                                <g:link controller="taskDetailed" 
                                                action="budget"
                                                params="[quickSearch: 'budgetUnplanned']">
                                                Unplanned Tasks
                                </g:link>
                            </td>
                        </tr>

                    </tbody>
                </table>
                <div class="buttons">
                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                    </span>
<!--                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.clear.text', default:'Clear')}" onclick="return clearFilterPane('searchForm');" />
                    </span>
                    <span class="button">
                        <g:actionSubmit class="search" value="Search" />
                    </span>-->
                </div>
            </g:form>
        </div> <!-- end search pane -->

    </body>
</html>
