<head>
    <meta name="layout" content="main" />
    <title>Edit Person</title>
    <nav:resources override="true"/>
</head>

<body>

    <div class="nav">
        <nav:renderSubItems group="navAlt"/>
    </div>

    <div class="body">
        <g:if test="${flash.message}">
        <div class="message">${flash.message}</div>
        </g:if>
        <g:if test="${params.message}">
            <div class="message">${params.message}</div>
        </g:if>
        <g:hasErrors bean="${person}">
        <div class="errors">
            <g:renderErrors bean="${person}" as="list" />
        </div>
        </g:hasErrors>

    <!--<div class="prop">
            <span class="name">ID: ${person.id}</span>
        </div>-->

        <g:form>
            <input type="hidden" name="id" value="${person.id}" />
            <input type="hidden" name="version" value="${person.version}" />
            <input type="hidden" name="password" value="${person.password}" />
            <div class="dialog">
                <table>
                <tbody>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="loginName">Login Name:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'loginName','errors')}">
                            <input type="text" id="loginName" name="loginName" value="${person.loginName?.encodeAsHTML()}"/>
                            <g:helpBalloon class="helpballoon" code="person.loginName" />
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="firstName">First Name:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'firstName','errors')}">
                            <input type="text" id="firstName" name="firstName" value="${person.firstName?.encodeAsHTML()}"/>
                            <g:helpBalloon class="helpballoon" code="person.firstName" />
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="lastName">Last Name:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'lastName','errors')}">
                            <input type="text" id="lastName" name="lastName" value="${person.lastName?.encodeAsHTML()}"/>
                            <g:helpBalloon class="helpballoon" code="person.lastName" />
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="pass">Password:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'pass','errors')}">
                            <input type="password" id="pass" name="pass"  value="${person.pass?.encodeAsHTML()}"/>
                            <g:helpBalloon class="helpballoon" code="person.password" />
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="isActive">Active:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'isActive','errors')}">
                            <g:checkBox name="isActive" value="${person.isActive}"/>
                            <g:helpBalloon class="helpballoon" code="person.isActive" />
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="description">Description:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'description','errors')}">
                            <input type="text" id="description" name="description" value="${person.description?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="email">Email:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'email','errors')}">
                            <input type="text" id="email" name="email" value="${person?.email?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="emailShow">Show Email:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'emailShow','errors')}">
                            <g:checkBox name="emailShow" value="${person.emailShow}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name">
                            <label for="addresses">Addresses:</label>
                        </td>
                        <td valign="top" class="value">
                            <ul>
                            <g:each var="i" in="${person?.addresses?}">
                                <li><g:link controller="addressDetailed" action="show" id="${i.id}">
                                    ${i?.encodeAsHTML()}
                                </g:link></li>
                            </g:each>
                            </ul>
                            <g:link controller="addressDetailed" params="['person.id':person?.id]" action="create">Add Address</g:link>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="employeeID">employee ID:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'employeeID','errors')}">
                            <input type="text" id="employeeID" name="employeeID" value="${person.employeeID?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name">
                            <label for="department">Department:</label>
                        </td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'department','errors')}">
                            <g:select optionKey="id" from="${Department.list()}" name="department.id" value="${person?.department?.id}" noSelection="['null':'--None--']"></g:select>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name">
                            <label for="personGroups">Groups:</label>
                        </td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'personGroups','errors')}">
                            <g:helpBalloon class="helpballoon" code="person.personGroups" />
                            <custom:checkBoxList name="personGroups"
                                                            from="${PersonGroup.list().sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }}"
                                                            value="${person?.personGroups?.collect{it.id}}"
                                                            optionKey="id"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name" align="left">
                            Authorities:
                        </td>
                        <td valign="top" class="name" align="left">
                            <g:helpBalloon class="helpballoon" code="person.authorities" />
                        </td>
                    </tr>

                    <g:each var="entry" in="${roleMap}">
                    <tr>
                        <td valign="top" class="name" align="left">${entry.key.description.encodeAsHTML()}</td>
                        <td align="left"><g:checkBox name="${entry.key.authority}" value="${entry.value}"/></td>
                    </tr>
                    </g:each>

                </tbody>
                </table>
            </div>

            <div class="buttons">
                <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
            </div>

        </g:form>

    </div>
</body>
