import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager'])
class SiteDetailedController extends BaseController {

    def siteService

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def index = { redirect(action:list,params:params) }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ siteInstanceList: Site.list( params ), siteInstanceTotal: Site.count() ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def siteInstance = Site.get( params.id )

        if(!siteInstance) {
            flash.message = "Site not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ siteInstance : siteInstance ] }
    }

    @Secured(['ROLE_AppAdmin'])
    def delete = {
        def result = siteService.delete(params)

        if(!result.error) {
            flash.message = g.message(code: "default.delete.success", args: ["Site", params.id])
            redirect(action:list)
            return
        }

        flash.errorMessage = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(action:list)
            return
        }

        redirect(action:show, id: params.id)
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def siteInstance = Site.get( params.id )

        if(!siteInstance) {
            flash.message = "Site not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ siteInstance : siteInstance ]
        }
    }

    def update = {
        def siteInstance = Site.get( params.id )
        if(siteInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(siteInstance.version > version) {
                    
                    siteInstance.errors.rejectValue("version", "site.optimistic.locking.failure", "Another user has updated this Site while you were editing.")
                    render(view:'edit',model:[siteInstance:siteInstance])
                    return
                }
            }
            siteInstance.properties = params
            if(!siteInstance.hasErrors() && siteInstance.save(flush: true)) {
                flash.message = "Site ${params.id} updated"
                redirect(action:show,id:siteInstance.id)
            }
            else {
                render(view:'edit',model:[siteInstance:siteInstance])
            }
        }
        else {
            flash.message = "Site not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def siteInstance = new Site()
        siteInstance.properties = params
        return ['siteInstance':siteInstance]
    }

    def save = {
        def siteInstance = new Site(params)
        if(!siteInstance.hasErrors() && siteInstance.save(flush: true)) {
            flash.message = "Site ${siteInstance.id} created"
            redirect(action:show,id:siteInstance.id)
        }
        else {
            render(view:'create',model:[siteInstance:siteInstance])
        }
    }
}
