import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager'])
class MaintenancePolicyDetailedController extends BaseController {

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ maintenancePolicyInstanceList: MaintenancePolicy.list( params ), maintenancePolicyInstanceTotal: MaintenancePolicy.count() ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def maintenancePolicyInstance = MaintenancePolicy.get( params.id )

        if(!maintenancePolicyInstance) {
            flash.message = "MaintenancePolicy not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ maintenancePolicyInstance : maintenancePolicyInstance ] }
    }

    def delete = {
        def maintenancePolicyInstance = MaintenancePolicy.get( params.id )
        if(maintenancePolicyInstance) {
            try {
                maintenancePolicyInstance.delete(flush:true)
                flash.message = "MaintenancePolicy ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "MaintenancePolicy ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "MaintenancePolicy not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def maintenancePolicyInstance = MaintenancePolicy.get( params.id )

        if(!maintenancePolicyInstance) {
            flash.message = "MaintenancePolicy not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ maintenancePolicyInstance : maintenancePolicyInstance ]
        }
    }

    def update = {
        def maintenancePolicyInstance = MaintenancePolicy.get( params.id )
        if(maintenancePolicyInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(maintenancePolicyInstance.version > version) {
                    
                    maintenancePolicyInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[maintenancePolicyInstance:maintenancePolicyInstance])
                    return
                }
            }
            maintenancePolicyInstance.properties = params
            if(!maintenancePolicyInstance.hasErrors() && maintenancePolicyInstance.save(flush: true)) {
                flash.message = "MaintenancePolicy ${params.id} updated"
                redirect(action:show,id:maintenancePolicyInstance.id)
            }
            else {
                render(view:'edit',model:[maintenancePolicyInstance:maintenancePolicyInstance])
            }
        }
        else {
            flash.message = "MaintenancePolicy not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def maintenancePolicyInstance = new MaintenancePolicy()
        maintenancePolicyInstance.properties = params
        return ['maintenancePolicyInstance':maintenancePolicyInstance]
    }

    def save = {
        def maintenancePolicyInstance = new MaintenancePolicy(params)
        if(!maintenancePolicyInstance.hasErrors() && maintenancePolicyInstance.save(flush: true)) {
            flash.message = "MaintenancePolicy ${maintenancePolicyInstance.id} created"
            redirect(action:show,id:maintenancePolicyInstance.id)
        }
        else {
            render(view:'create',model:[maintenancePolicyInstance:maintenancePolicyInstance])
        }
    }
}
