import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskRecurringScheduleController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskRecurringScheduleInstanceList: TaskRecurringSchedule.list( params ), taskRecurringScheduleInstanceTotal: TaskRecurringSchedule.count() ]
    }

    def show = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )

        if(!taskRecurringScheduleInstance) {
            flash.message = "TaskRecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskRecurringScheduleInstance : taskRecurringScheduleInstance ] }
    }

    def delete = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )
        if(taskRecurringScheduleInstance) {
            try {
                taskRecurringScheduleInstance.delete(flush:true)
                flash.message = "TaskRecurringSchedule ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskRecurringSchedule ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskRecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )

        if(!taskRecurringScheduleInstance) {
            flash.message = "TaskRecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskRecurringScheduleInstance : taskRecurringScheduleInstance ]
        }
    }

    def update = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )
        if(taskRecurringScheduleInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskRecurringScheduleInstance.version > version) {
                    
                    taskRecurringScheduleInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[taskRecurringScheduleInstance:taskRecurringScheduleInstance])
                    return
                }
            }
            taskRecurringScheduleInstance.properties = params
            if(!taskRecurringScheduleInstance.hasErrors() && taskRecurringScheduleInstance.save(flush: true)) {
                flash.message = "TaskRecurringSchedule ${params.id} updated"
                redirect(action:show,id:taskRecurringScheduleInstance.id)
            }
            else {
                render(view:'edit',model:[taskRecurringScheduleInstance:taskRecurringScheduleInstance])
            }
        }
        else {
            flash.message = "TaskRecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def taskRecurringScheduleInstance = new TaskRecurringSchedule()
        taskRecurringScheduleInstance.properties = params
        return ['taskRecurringScheduleInstance':taskRecurringScheduleInstance]
    }

    def save = {
        def taskRecurringScheduleInstance = new TaskRecurringSchedule(params)
        if(!taskRecurringScheduleInstance.hasErrors() && taskRecurringScheduleInstance.save(flush: true)) {
            flash.message = "TaskRecurringSchedule ${taskRecurringScheduleInstance.id} created"
            redirect(action:show,id:taskRecurringScheduleInstance.id)
        }
        else {
            render(view:'create',model:[taskRecurringScheduleInstance:taskRecurringScheduleInstance])
        }
    }
}
