import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager'])
class CostCodeDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ costCodeInstanceList: CostCode.list( params ), costCodeInstanceTotal: CostCode.count() ]
    }

    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def costCodeInstance = CostCode.get( params.id )

        if(!costCodeInstance) {
            flash.message = "CostCode not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ costCodeInstance : costCodeInstance ] }
    }

    def delete = {
        def costCodeInstance = CostCode.get( params.id )
        if(costCodeInstance) {
            try {
                costCodeInstance.delete(flush:true)
                flash.message = "CostCode ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "CostCode ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "CostCode not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def costCodeInstance = CostCode.get( params.id )

        if(!costCodeInstance) {
            flash.message = "CostCode not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ costCodeInstance : costCodeInstance ]
        }
    }

    def update = {
        def costCodeInstance = CostCode.get( params.id )
        if(costCodeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(costCodeInstance.version > version) {
                    
                    costCodeInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[costCodeInstance:costCodeInstance])
                    return
                }
            }
            costCodeInstance.properties = params
            if(!costCodeInstance.hasErrors() && costCodeInstance.save(flush: true)) {
                flash.message = "CostCode ${params.id} updated"
                redirect(action:show,id:costCodeInstance.id)
            }
            else {
                render(view:'edit',model:[costCodeInstance:costCodeInstance])
            }
        }
        else {
            flash.message = "CostCode not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def costCodeInstance = new CostCode()
        costCodeInstance.properties = params
        return ['costCodeInstance':costCodeInstance]
    }

    def save = {
        def costCodeInstance = new CostCode(params)
        if(!costCodeInstance.hasErrors() && costCodeInstance.save(flush: true)) {
            flash.message = "CostCode ${costCodeInstance.id} created"
            redirect(action:show,id:costCodeInstance.id)
        }
        else {
            render(view:'create',model:[costCodeInstance:costCodeInstance])
        }
    }
}
