import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssignedGroupController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ assignedGroupInstanceList: AssignedGroup.list( params ), assignedGroupInstanceTotal: AssignedGroup.count() ]
    }

    def show = {
        def assignedGroupInstance = AssignedGroup.get( params.id )

        if(!assignedGroupInstance) {
            flash.message = "AssignedGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ assignedGroupInstance : assignedGroupInstance ] }
    }

    def delete = {
        def assignedGroupInstance = AssignedGroup.get( params.id )
        if(assignedGroupInstance) {
            try {
                assignedGroupInstance.delete(flush:true)
                flash.message = "AssignedGroup ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AssignedGroup ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AssignedGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def assignedGroupInstance = AssignedGroup.get( params.id )

        if(!assignedGroupInstance) {
            flash.message = "AssignedGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ assignedGroupInstance : assignedGroupInstance ]
        }
    }

    def update = {
        def assignedGroupInstance = AssignedGroup.get( params.id )
        if(assignedGroupInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assignedGroupInstance.version > version) {
                    
                    assignedGroupInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[assignedGroupInstance:assignedGroupInstance])
                    return
                }
            }
            assignedGroupInstance.properties = params
            if(!assignedGroupInstance.hasErrors() && assignedGroupInstance.save(flush: true)) {
                flash.message = "AssignedGroup ${params.id} updated"
                redirect(action:show,id:assignedGroupInstance.id)
            }
            else {
                render(view:'edit',model:[assignedGroupInstance:assignedGroupInstance])
            }
        }
        else {
            flash.message = "AssignedGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def assignedGroupInstance = new AssignedGroup()
        assignedGroupInstance.properties = params
        return ['assignedGroupInstance':assignedGroupInstance]
    }

    def save = {
        def assignedGroupInstance = new AssignedGroup(params)
        if(!assignedGroupInstance.hasErrors() && assignedGroupInstance.save(flush: true)) {
            flash.message = "AssignedGroup ${assignedGroupInstance.id} created"
            redirect(action:show,id:assignedGroupInstance.id)
        }
        else {
            render(view:'create',model:[assignedGroupInstance:assignedGroupInstance])
        }
    }
}
