<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Immediate Callout</title>
        <nav:resources override="true"/>
        <resource:dateChooser />
    </head>
    <body onload="document.createTaskForm.description.focus();">
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <g:hasErrors>
                <div class="errors">
                    <ul>
                        <g:eachError bean="${taskInstance}">
                            <li><g:message error="${it}" /></li>
                        </g:eachError>
                        <g:eachError bean="${entryFaultInstance}">
                            <li><g:message error="${it}" /></li>
                        </g:eachError>
                        <g:eachError bean="${entryCauseInstance}">
                            <li><g:message error="${it}" /></li>
                        </g:eachError>
                        <g:eachError bean="${entryWorkDoneInstance}">
                            <li><g:message error="${it}" /></li>
                        </g:eachError>
                    </ul>
                </div>
            </g:hasErrors>

            <g:form action="saveImmediateCallout" method="post" name="createTaskForm">
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Callout Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'description','errors')}">
                                    <input type="text"  class="description" maxlength="75" id="description" name="description" value="${fieldValue(bean:taskInstance,field:'description')}"/>
                                    <g:helpBalloon class="helpballoon" code="task.description.immediateCallout" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetStartDate">Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetStartDate','errors')}">
                                    <richui:dateChooser name="targetStartDate" format="dd-MM-yyyy" value="${taskInstance.targetStartDate}" />
                                    <g:helpBalloon class="helpballoon" code="task.targetStartDate.immediateCallout" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="primaryAsset">Asset:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'primaryAsset','errors')}">
                                    <g:select optionKey="id" from="${Asset.list()}" name="primaryAsset.id" value="${taskInstance?.primaryAsset?.id}" noSelection="['null':'--None--']"></g:select>
                                    <g:helpBalloon code="task.primaryAsset" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="productionReference">Production:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryFaultInstance,field:'productionReference','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ProductionReference.findAllByIsActive(true)}"
                                                        name="entryFault.productionReference.id"
                                                        value="${entryFaultInstance?.productionReference?.id}"
                                                        noSelection="['null':'--None--']">
                                    </g:select>
                                    <g:helpBalloon code="entry.productionReference.fault" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="durationHour">Down Time:</label>
                                </td>

                                <td valign="top" class="value">
                                    <input class="time ${hasErrors(bean:entryFaultInstance,field:'durationHour','errors')}"
                                        type="text" id="entryFault.durationHour" name="entryFault.durationHour"
                                        value="${fieldValue(bean:entryFaultInstance,field:'durationHour')}" />
                                    :
                                    <input class="time ${hasErrors(bean:entryFaultInstance,field:'durationMinute','errors')}"
                                        type="text" id="entryFault.durationMinute" name="entryFault.durationMinute" 
                                        value="${fieldValue(bean:entryFaultInstance,field:'durationMinute')}" />
                                    <g:helpBalloon code="entry.duration.fault" />
                                </td> 
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">${entryFaultInstance?.entryType.encodeAsHTML()}:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryFaultInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="entryFault.comment">${fieldValue(bean:entryFaultInstance, field:'comment')}</textarea>
                                        <g:helpBalloon code="entry.comment.fault" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">${entryCauseInstance?.entryType.encodeAsHTML()}:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryCauseInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="entryCause.comment">${fieldValue(bean:entryCauseInstance, field:'comment')}</textarea>
                                        <g:helpBalloon code="entry.comment.cause" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">${entryWorkDoneInstance?.entryType.encodeAsHTML()}:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryWorkDoneInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="entryWorkDone.comment">${fieldValue(bean:entryWorkDoneInstance, field:'comment')}</textarea>
                                        <g:helpBalloon code="entry.comment.work.done" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="durationHour">Work Duration:</label>
                                </td>

                                <td valign="top" class="value">
                                    <input class="time ${hasErrors(bean:entryWorkDoneInstance,field:'durationHour','errors')}"
                                        type="text" id="entryWorkDone.durationHour" name="entryWorkDone.durationHour"
                                        value="${fieldValue(bean:entryWorkDoneInstance,field:'durationHour')}" />
                                    :
                                    <input class="time ${hasErrors(bean:entryWorkDoneInstance,field:'durationMinute','errors')}"
                                        type="text" id="entryWorkDone.durationMinute" name="entryWorkDone.durationMinute" 
                                        value="${fieldValue(bean:entryWorkDoneInstance,field:'durationMinute')}" />
                                    <g:helpBalloon code="entry.duration" />
                                </td> 
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
