

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Manufacturer</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${manufacturerInstance}">
            <div class="errors">
                <g:renderErrors bean="${manufacturerInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${manufacturerInstance?.id}" />
                <input type="hidden" name="version" value="${manufacturerInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:manufacturerInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:manufacturerInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:manufacturerInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:manufacturerInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:manufacturerInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${manufacturerInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturerType">Manufacturer Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:manufacturerInstance,field:'manufacturerType','errors')}">
                                    <g:select optionKey="id" from="${ManufacturerType.list()}" name="manufacturerType.id" value="${manufacturerInstance?.manufacturerType?.id}" ></g:select>
                                </td>
                            </tr> 

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="addresses">Contact:</label>
                                </td>
                                <td valign="top" class="value">
                                    <ul>
                                    <g:each var="i" in="${manufacturerInstance?.contacts}">
                                        <li><g:link controller="contactDetailed" action="show" id="${i.id}">
                                            ${i?.encodeAsHTML()}
                                        </g:link></li>
                                    </g:each>
                                    </ul>
                                    <g:link controller="contactDetailed" params="['manufacturer.id':manufacturerInstance?.id]" action="create">+Add Contact</g:link>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="addresses">Addresses:</label>
                                </td>
                                <td valign="top" class="value">
                                    <ul>
                                    <g:each var="i" in="${manufacturerInstance?.addresses?}">
                                        <li><g:link controller="manufacturerDetailed" action="show" id="${i.id}">
                                            ${i?.encodeAsHTML()}
                                        </g:link></li>
                                    </g:each>
                                    </ul>
                                    <g:link controller="addressDetailed" params="['manufacturer.id':manufacturerInstance?.id]" action="create">+Add Address</g:link>
                                </td>
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
