class EntryTypeController extends BaseController {

    def beforeInterceptor = [action:this.&auth]

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ entryTypeInstanceList: EntryType.list( params ) ]
    }

    def show = {
        def entryTypeInstance = EntryType.get( params.id )

        if(!entryTypeInstance) {
            flash.message = "EntryType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ entryTypeInstance : entryTypeInstance ] }
    }

    def delete = {
        def entryTypeInstance = EntryType.get( params.id )
        if(entryTypeInstance) {
            entryTypeInstance.delete()
            flash.message = "EntryType ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "EntryType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def entryTypeInstance = EntryType.get( params.id )

        if(!entryTypeInstance) {
            flash.message = "EntryType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ entryTypeInstance : entryTypeInstance ]
        }
    }

    def update = {
        def entryTypeInstance = EntryType.get( params.id )
        if(entryTypeInstance) {
            entryTypeInstance.properties = params
            if(!entryTypeInstance.hasErrors() && entryTypeInstance.save()) {
                flash.message = "EntryType ${params.id} updated"
                redirect(action:show,id:entryTypeInstance.id)
            }
            else {
                render(view:'edit',model:[entryTypeInstance:entryTypeInstance])
            }
        }
        else {
            flash.message = "EntryType not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def entryTypeInstance = new EntryType()
        entryTypeInstance.properties = params
        return ['entryTypeInstance':entryTypeInstance]
    }

    def save = {
        def entryTypeInstance = new EntryType(params)
        if(!entryTypeInstance.hasErrors() && entryTypeInstance.save()) {
            flash.message = "EntryType ${entryTypeInstance.id} created"
            redirect(action:show,id:entryTypeInstance.id)
        }
        else {
            render(view:'create',model:[entryTypeInstance:entryTypeInstance])
        }
    }
}
