import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class LifePlanController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ lifePlanInstanceList: LifePlan.list( params ), lifePlanInstanceTotal: LifePlan.count() ]
    }

    def show = {
        def lifePlanInstance = LifePlan.get( params.id )

        if(!lifePlanInstance) {
            flash.message = "LifePlan not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ lifePlanInstance : lifePlanInstance ] }
    }

    def delete = {
        def lifePlanInstance = LifePlan.get( params.id )
        if(lifePlanInstance) {
            try {
                lifePlanInstance.delete(flush:true)
                flash.message = "LifePlan ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "LifePlan ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "LifePlan not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def lifePlanInstance = LifePlan.get( params.id )

        if(!lifePlanInstance) {
            flash.message = "LifePlan not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ lifePlanInstance : lifePlanInstance ]
        }
    }

    def update = {
        def lifePlanInstance = LifePlan.get( params.id )
        if(lifePlanInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(lifePlanInstance.version > version) {
                    
                    lifePlanInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[lifePlanInstance:lifePlanInstance])
                    return
                }
            }
            lifePlanInstance.properties = params
            if(!lifePlanInstance.hasErrors() && lifePlanInstance.save(flush: true)) {
                flash.message = "LifePlan ${params.id} updated"
                redirect(action:show,id:lifePlanInstance.id)
            }
            else {
                render(view:'edit',model:[lifePlanInstance:lifePlanInstance])
            }
        }
        else {
            flash.message = "LifePlan not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def lifePlanInstance = new LifePlan()
        lifePlanInstance.properties = params
        return ['lifePlanInstance':lifePlanInstance]
    }

    def save = {
        def lifePlanInstance = new LifePlan(params)
        if(!lifePlanInstance.hasErrors() && lifePlanInstance.save(flush: true)) {
            flash.message = "LifePlan ${lifePlanInstance.id} created"
            redirect(action:show,id:lifePlanInstance.id)
        }
        else {
            render(view:'create',model:[lifePlanInstance:lifePlanInstance])
        }
    }
}
