
function updateQuickSearchSelection() {
    var personsTasksSelectionIds = ['personLabel', 'personSelection', 'completedLabel', 'completedSelection'];
    var helpBalloonSpanIds = ['allTasksHelp', 'budgetPlannedHelp', 'budgetUnplannedHelp', 'personsTasksHelp', 'personsImmediateCalloutsHelp'];
    var val = $("quickSearchSelect").value;

    $A(HelpBalloon._balloons).invoke('hide'); // Hide any open balloons.
    helpBalloonSpanIds.each(Element.hide); // Hide all help icons.

    switch(val)
    {
        case 'allTasks':
            showUtil('allTasksHelp');
            hideArrayUtil(personsTasksSelectionIds);
            break;
        case 'budgetPlanned':
            showUtil('budgetPlannedHelp');
            hideArrayUtil(personsTasksSelectionIds);
            break;
        case 'budgetUnplanned':
            showUtil('budgetUnplannedHelp');
            hideArrayUtil(personsTasksSelectionIds);
            break;
        case 'personsTasks':
            showUtil('personsTasksHelp');
            showArrayUtil(personsTasksSelectionIds);
            break;
        case 'personsImmediateCallouts':
            showUtil('personsImmediateCalloutsHelp');
            showArrayUtil(personsTasksSelectionIds);
            break;
    }

}

Event.observe(window, 'load', function() {
    updateQuickSearchSelection(); // Initial page load.
    $A(HelpBalloon._balloons).invoke('show'); // Work around for offset balloon when using a pane in IE.
    $A(HelpBalloon._balloons).invoke('hide'); // Work around for offset balloon when using a pane in IE.
    $("quickSearchSelect").observe('change', updateQuickSearchSelection); // Register onchange handler.
});
