import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskStatusController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskStatusInstanceList: TaskStatus.list( params ), taskStatusInstanceTotal: TaskStatus.count() ]
    }

    def show = {
        def taskStatusInstance = TaskStatus.get( params.id )

        if(!taskStatusInstance) {
            flash.message = "TaskStatus not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskStatusInstance : taskStatusInstance ] }
    }

    def delete = {
        def taskStatusInstance = TaskStatus.get( params.id )
        if(taskStatusInstance) {
            try {
                taskStatusInstance.delete(flush:true)
                flash.message = "TaskStatus ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskStatus ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskStatus not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskStatusInstance = TaskStatus.get( params.id )

        if(!taskStatusInstance) {
            flash.message = "TaskStatus not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskStatusInstance : taskStatusInstance ]
        }
    }

    def update = {
        def taskStatusInstance = TaskStatus.get( params.id )
        if(taskStatusInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskStatusInstance.version > version) {
                    
                    taskStatusInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[taskStatusInstance:taskStatusInstance])
                    return
                }
            }
            taskStatusInstance.properties = params
            if(!taskStatusInstance.hasErrors() && taskStatusInstance.save(flush: true)) {
                flash.message = "TaskStatus ${params.id} updated"
                redirect(action:show,id:taskStatusInstance.id)
            }
            else {
                render(view:'edit',model:[taskStatusInstance:taskStatusInstance])
            }
        }
        else {
            flash.message = "TaskStatus not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def taskStatusInstance = new TaskStatus()
        taskStatusInstance.properties = params
        return ['taskStatusInstance':taskStatusInstance]
    }

    def save = {
        def taskStatusInstance = new TaskStatus(params)
        if(!taskStatusInstance.hasErrors() && taskStatusInstance.save(flush: true)) {
            flash.message = "TaskStatus ${taskStatusInstance.id} created"
            redirect(action:show,id:taskStatusInstance.id)
        }
        else {
            render(view:'create',model:[taskStatusInstance:taskStatusInstance])
        }
    }
}
