<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show Task #${taskInstance.id}</title>
        <nav:resources override="true"/>
        <resource:tabView skin="tabviewCustom" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:if test="${taskInstance.trash}" >
                <div class="errors">
                        <ul><li>This task is in the trash bin, but can be restored if required.<li><ul>
                </div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>

            <div class="tabHeader">
                <h1>
                    Task #${taskInstance.id}

                    <g:if test="${taskInstance.approved}" >
                        <img  src="${resource(dir:'images/skin',file:'cog.png')}" alt="Approved" title="Approved" />
                    </g:if>
                    <g:if test="${taskRecurringScheduleInstance?.enabled}" >
                        <img  src="${resource(dir:'images/skin',file:'arrow_refresh.png')}" alt="Recurrence Enabled" title="Recurrence Enabled" />
                    </g:if>
                    <g:if test="${taskInstance.taskStatus.id == 2}" >
                        <img  src="${resource(dir:'images/skin',file:'arrow_right.png')}" alt="In Progress" title="In Progress" />
                    </g:if>
                    <g:if test="${taskInstance.attentionFlag}" >
                        <img  src="${resource(dir:'images/skin',file:'flag_red.png')}" alt="Attention Flag" title="Attention Flag" />
                    </g:if>
                    <g:if test="${taskInstance.taskStatus.id == 3}" >
                        <img  src="${resource(dir:'images/skin',file:'tick.png')}" alt="Complete" title="Complete" />
                    </g:if>
                </h1>
                <g:if test="${taskInstance.primaryAsset}" >
                    ${fieldValue(bean:taskInstance, field:'primaryAsset')}:
                </g:if>
                ${fieldValue(bean:taskInstance, field:'description')}
                <g:if test="${taskInstance.safetyRequirement}" >
                    <img  src="${resource(dir:'images/skin',file:'lightning.png')}" alt="Safety Requirement" title="Safety Requirement" />
                    Safety
                </g:if>
                <g:if test="${taskInstance.regulatoryRequirement}" >
                    <img  src="${resource(dir:'images/skin',file:'script_lightning.png')}" alt="Regulatory Requirement" title="Regulatory Requirement" />
                    Regulatory
                </g:if>
                <g:if test="${taskInstance.mandatoryRequirement}" >
                    <img  src="${resource(dir:'images/skin',file:'script.png')}" alt="Mandatory Requirement" title="Mandatory Requirement" />
                    Mandatory
                </g:if>
            </div>

            <br/>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="${showTab.task}" title="Details" />
                    <g:if test="${taskProcedureExits}">
                        <richui:tabLabel selected="${showTab.procedure}" title="Procedure (!)" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.procedure}" title="Procedure" />
                    </g:else>
                    <g:if test="${taskRecurringScheduleExits}">
                        <richui:tabLabel selected="${showTab.recurrence}" title="Recurrence (!)" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.recurrence}" title="Recurrence" />
                    </g:else>
                    <g:if test="${!inventoryMovementList.isEmpty()}">
                        <richui:tabLabel selected="${showTab.inventory}" title="Inventory (${inventoryMovementList.size()})" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.inventory}" title="Inventory (0)" />
                    </g:else>
                    <g:if test="${subTaskInstanceTotal > 0}">
                        <richui:tabLabel selected="${showTab.subTasks}" title="Sub Tasks (${subTaskInstanceTotal})" />
                    </g:if>
                    <g:else>
                        <richui:tabLabel selected="${showTab.subTasks}" title="Sub Tasks (0)" />
                    </g:else>
                </richui:tabLabels>

                <richui:tabContents>

<!-- Start Task tab -->
                    <richui:tabContent>

                        <div class="dialog">
                            <table>
                                <tbody>

                                    <g:if test="${taskInstance.parentTask}">
                                        <tr class="prop">
                                            <td valign="top" class="name">Parent Task:</td>

                                            <td valign="top" class="value">
                                                <g:link controller="taskDetailed" action="show" id="${taskInstance.parentTask.id}">
                                                    ${taskInstance.parentTask.encodeAsHTML()}
                                                </g:link>
                                            </td>

                                        </tr>
                                    </g:if>

                                    <tr class="prop">
                                        <td valign="top" class="name">Comment:</td>

                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'comment')}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Target Start:</td>

                                        <td valign="top" class="value">
                                            <g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                                        </td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Target Completion:</td>

                                        <td valign="top" class="value">
                                            <g:formatDate date="${taskInstance.targetCompletionDate}" format="EEE, dd-MMM-yyyy"/>
                                        </td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">

                                            <jsUtil:toggleControl toggleId="modifications"
                                                                                    imageId="modificationsImg"
                                                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_toggle_plus.png')}"
                                                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_toggle_minus.png')}"
                                                                                    effect="fade"
                                                                                    text="Modifications"
                                                                                    />
                                        </td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <div id="modifications" style="display:none;">
                                                <ul>
                                                <g:each var="a" in="${taskModificationList}">
                                                    <li>${a?.encodeAsHTML()}</li>
                                                </g:each>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Primary Asset:</td>

                                        <td valign="top" class="value"><g:link controller="assetDetailed" action="show" id="${taskInstance?.primaryAsset?.id}">${taskInstance?.primaryAsset?.encodeAsHTML()}</g:link></td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Associated Assets:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="a" in="${taskInstance.associatedAssets}">
                                                <li>${a?.encodeAsHTML()}</li>
                                            </g:each>
                                            </ul>
                                        </td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Priority:</td>

                                        <td valign="top" class="value">${taskInstance?.taskPriority?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Positive Fault:</td>

                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'positiveFault')}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Group:</td>

                                        <td valign="top" class="value">${taskInstance?.taskGroup?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Type:</td>

                                        <td valign="top" class="value">${taskInstance?.taskType?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Lead Person:</td>

                                        <td valign="top" class="value">${taskInstance?.leadPerson?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Assigned Groups:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="a" in="${assignedGroupList}">
                                                <li><g:link controller="assignedGroupDetailed" action="edit" id="${a.id}" params="['task.id':taskInstance.id]">${a?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                            <g:link controller="assignedGroupDetailed" action="create" params="['task.id':taskInstance.id]">+Add Group</g:link>
                                        </td>

                                    </tr>


                                    <tr class="prop">
                                        <td valign="top" class="name">Assigned Persons:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="a" in="${assignedPersonList}">
                                                <li><g:link controller="assignedPersonDetailed" action="edit" id="${a.id}" params="['task.id':taskInstance.id]">${a?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                            <g:link controller="assignedPersonDetailed" action="create" params="['task.id':taskInstance?.id]">+Add Person</g:link>
                                        </td>

                                    </tr>

                                </tbody>
                            </table>
                        </div>

                        <div class="buttons">
                            <g:form>
                                <input type="hidden" name="id" value="${taskInstance?.id}" />

                                <g:if test="${taskInstance.trash}" >
                                    <span class="button"><g:actionSubmit class="restore" onclick="return confirm('Are you sure?');" value="Restore"/></span>
                                </g:if>
                                <g:else>

                                    <g:if test="${taskInstance.taskStatus.id != 3}" >

                                        <g:if test="${taskInstance.attentionFlag}" >
                                            <span class="button"><g:actionSubmit class="flag" value="Clear" action="clearAttentionFlag"/></span>
                                        </g:if>
                                        <g:else>
                                            <span class="button"><g:actionSubmit class="flag" value="Unresolved" action="setAttentionFlag"/></span>
                                            <g:helpBalloon class="helpballoon" code="task.status.unresolved" />
                                        </g:else>

                                        <span class="button">
                                            <g:if test="${taskInstance.attentionFlag}" >
                                                <g:actionSubmit class="complete"
                                                                        value="Resolved"
                                                                        onclick="return confirm('${message(code:'task.clear.attention.flag.on.completion.confirm')}');"
                                                                        action="complete"/>
                                            </g:if>
                                            <g:else>
                                                <g:actionSubmit class="complete" value="Resolved" action="complete"/>
                                            </g:else>
                                        </span>
                                        <g:helpBalloon class="helpballoon" code="task.status.resolved" />

                                        <g:if test="${taskInstance.approved}" >
                                            <span class="button"><g:actionSubmit class="renegeApproval" value="Renege Approval" action="renegeApproval" /></span>
                                        </g:if>
                                        <g:else>
                                            <span class="button"><g:actionSubmit class="approve" value="Approve" /></span>
                                        </g:else>

                                        <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                        <span class="button">
                                            <g:actionSubmit class="trash"
                                                                        onclick="return confirm('${message(code:'task.trash.confirm')}');"
                                                                        value="Trash" />
                                        </span>

                                    </g:if>
                                    <g:else>
                                        <span class="button"><g:actionSubmit class="reopen" value="Reopen" /></span>
                                    </g:else>

                                </g:else>
                            </g:form>
                        </div>

                        <br />

                        <g:if test="${entryFaultList.isEmpty()}">
                            <h1>No Faults</h1>
                            <br />
                        </g:if>
                        <g:else>
                            <div class="list">
                                <h1>Faults</h1>
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Comment</th>
                                            <th>Date</th>
                                            <th>Production</th>
                                            <th>Down Time</th>
                                            <th>Entered By</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${entryFaultList}" status="i" var="entry">
                                                <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                                    <td style="width:65%" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.comment.encodeAsHTML()}
                                                    </td>

                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        <g:formatDate date="${entry.dateDone}" format="EEE, dd-MMM-yyyy"/>
                                                    </td>

                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        <g:if test="${entry.productionReference}">
                                                            ${entry.productionReference.encodeAsHTML()}
                                                        </g:if>
                                                        <g:else>
                                                            <g:message code="default.none.text" />
                                                        </g:else>
                                                    </td>

                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.durationHour}:${entry.durationMinute}
                                                    </td>

                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.enteredBy.encodeAsHTML()}
                                                    </td>

                                                    <td class="notClickable">
                                                        <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                                            <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" title="Edit" />
                                                        </g:link>
                                                    </td>

                                                </tr>
                                        </g:each>
                                    </tbody>
                                </table>
                            </div>
                        </g:else>

                        <div class="buttons">
                            <g:form controller="entryDetailed">
                                <g:hiddenField name="taskInstance.id" value="${taskInstance?.id}" />
                                <g:hiddenField name="entryType.id" value="1" />
                                <span class="button">
                                    <g:actionSubmit value="Add Fault" action="create"  class="add"/>
                                </span>
                            </g:form>
                        </div>

                        <br />

                        <g:if test="${entryCauseList.isEmpty()}">
                            <h1>No Causes</h1>
                            <br />
                        </g:if>
                        <g:else>
                            <div class="list">
                                <h1>Causes</h1>
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Comment</th>
                                            <th>Date Done</th>
                                            <th>Entered By</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${entryCauseList}" status="i" var="entry">
                                                <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                                    <td style="width:65%" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.comment.encodeAsHTML()}
                                                    </td>

                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        <g:formatDate date="${entry.dateDone}" format="EEE, dd-MMM-yyyy"/>
                                                    </td>

                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.enteredBy.encodeAsHTML()}
                                                    </td>

                                                    <td class="notClickable">
                                                        <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                                            <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" title="Edit" />
                                                        </g:link>
                                                    </td>

                                                </tr>
                                        </g:each>
                                    </tbody>
                                </table>
                            </div>
                        </g:else>

                        <div class="buttons">
                            <g:form controller="entryDetailed">
                                <g:hiddenField name="taskInstance.id" value="${taskInstance?.id}" />
                                <g:hiddenField name="entryType.id" value="2" />
                                <span class="button">
                                    <g:actionSubmit value="Add Cause" action="create"  class="add"/>
                                </span>
                            </g:form>
                        </div>

                        <br />

                        <g:if test="${entryWorkDoneList.isEmpty()}">
                            <h1>No Work Done</h1>
                            <br />
                        </g:if>
                        <g:else>
                            <div class="list">
                                <h1>Work Done</h1>
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Comment</th>
                                            <th>Date Done</th>
                                            <th>Duration</th>
                                            <th>Entered By</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${entryWorkDoneList}" status="i" var="entry">
                                                <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                                    <td width="65%" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.comment.encodeAsHTML()}
                                                    </td>
                                                    
                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        <g:formatDate date="${entry.dateDone}" format="EEE, dd-MMM-yyyy"/>
                                                    </td>
                                                    
                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.durationHour}:${entry.durationMinute}
                                                    </td>
                                                    
                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.enteredBy.encodeAsHTML()}
                                                    </td>

                                                    <td class="notClickable">
                                                        <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                                            <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" title="Edit" />
                                                        </g:link>
                                                    </td>

                                                </tr>
                                        </g:each>
                                    </tbody>
                                </table>
                            </div>
                        </g:else>

                        <div class="buttons">
                            <g:form controller="entryDetailed">
                                <g:hiddenField name="taskInstance.id" value="${taskInstance?.id}" />
                                <g:hiddenField name="entryType.id" value="3" />
                                <span class="button">
                                    <g:actionSubmit value="Add Work Done" action="create"  class="add"/>
                                </span>
                            </g:form>
                        </div>
                    </richui:tabContent>
<!-- End Task tab -->


<!-- Start Task Procedure tab-->
                    <richui:tabContent>
                        <g:if test="${!taskProcedureExits}">
                            <br />
                            No Procedure linked.
                            <br />
                            <br />
                            <g:form controller="taskProcedureDetailed" >
                                <g:hiddenField name="taskInstance.id" value="${taskInstance?.id}" />

                                <div class="buttons">
                                    <span class="button">
                                        <g:actionSubmit value="New" action="create" class="add"/>
                                    </span>
                                    <span class="button">
                                        <g:actionSubmit value="Search" action="search" class="search"/>
                                    </span>
                                </div>

                            </g:form>

                        </g:if>
                        <g:else>
                            <div class="dialog">
                                <table>
                                    <tbody>

                                        <tr class="prop">
                                            <td valign="top" class="name">Procedure Id:</td>
                                            <td valign="top" class="value">
                                                ${fieldValue(bean:taskProcedureInstance, field:'id')}
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Linked Task:</td>
                                            <td valign="top" class="value">
                                                <g:link controller="taskDetailed"
                                                                action="show"
                                                                id="${taskProcedureInstance.linkedTask.id}">
                                                    ${taskProcedureInstance.linkedTask.encodeAsHTML()}
                                                </g:link>
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Linked Asset:</td>
                                            <td valign="top" class="value">
                                                <g:render template="/shared/assetTreeCompact" model="['assetInstance': taskProcedureInstance.linkedTask.primaryAsset]" />
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Version:</td>
                                            <td valign="top" class="value">
                                                    ${fieldValue(bean:taskProcedureInstance, field:'version')}
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Last Updated:</td>
                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskProcedureInstance.lastUpdated}"
                                                                            format="EEE, dd-MMM-yyyy"/>
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                            <div class="buttons">
                                <g:form controller="taskProcedureDetailed">
                                    <input type="hidden" name="id" value="${taskProcedureInstance?.id}" />
                                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                </g:form>
                            </div>

                            <br />

                            <g:if test="${taskProcedureInstance.documentReferences}">
                                <div class="list">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>Document Reference</th>
                                                <th>Location</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <g:each in="${taskProcedureInstance.documentReferences}" status="i" var="docRef">
                                                <tr class="${(i % 2) == 0 ? 'odd' : 'even'}">

                                                    <td valign="top" class="name">
                                                        ${fieldValue(bean:docRef, field:'name')}
                                                    </td>

                                                    <td  valign="top" style="text-align:left;" class="value">
                                                        <custom:easyUrl url="${docRef.location}" />
                                                    </td>

                                                </tr>
                                            </g:each>

                                        </tbody>
                                    </table>
                                </div>
                            </g:if>

                            <br />

                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Step</th>
                                            <th>Assembly</th>
                                            <th>Description</th>
                                            <th>Page Ref</th>
                                            <th>Condition</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${maintenanceActionList}" status="i" var="maintenanceAction">
                                            <tr class="${(i % 2) == 0 ? 'odd' : 'even'}">

                                                <td valign="top" class="name">
                                                    ${fieldValue(bean:maintenanceAction, field:'procedureStepNumber')}
                                                </td>

                                                <td  valign="top" style="text-align:left;" class="value">
                                                    <g:if test="${maintenanceAction.assetSubItem}">
                                                        ${maintenanceAction.assetSubItem.parentItem?.encodeAsHTML()}
                                                        --
                                                        ${maintenanceAction.assetSubItem.encodeAsHTML()}
                                                    </g:if>
                                                </td>

                                                <td  valign="top" style="text-align:left;" class="value">
                                                    ${fieldValue(bean:maintenanceAction, field:'description')}
                                                </td>

                                                <td  valign="top" style="text-align:left;" class="value">
                                                    ${fieldValue(bean:maintenanceAction, field:'pageRef')}
                                                </td>

                                                <td  valign="top" style="text-align:left;" class="value">
                                                </td>

                                            </tr>
                                        </g:each>

                                    </tbody>
                                </table>
                            </div>

                        </g:else>

                    </richui:tabContent>
<!-- End Task Procedure tab-->

<!-- Start Task Recurrence tab -->
                    <richui:tabContent>

                        <g:if test="${!taskRecurringScheduleExits}">
                            <br />
                            No Recurring Schedule.
                            <br />
                            <br />
                            <g:form controller="taskRecurringScheduleDetailed" >
                                <g:hiddenField name="task.id" value="${taskInstance.id}" />

                                <div class="buttons">
                                    <span class="button">
                                        <g:actionSubmit value="Add" action="create" class="add" />
                                    </span>
                                </div>

                            </g:form>

                        </g:if>
                        <g:else>

                        <div class="dialog">
                                <table>
                                    <tbody>
                                        <tr class="prop">
                                            <td valign="top" class="name">Recurring Schedule:</td>

                                            <td valign="top" class="value">${taskRecurringScheduleInstance.encodeAsHTML()}</td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Enabled:</td>

                                            <td valign="top" class="value">${fieldValue(bean:taskRecurringScheduleInstance, field:'enabled')}</td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Next Generation Date:</td>

                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.nextGenerationDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Generate Ahead:</td>

                                            <td valign="top" class="value">
                                                ${taskRecurringScheduleInstance?.generateAhead} ${Period.get(1).encodeAsHTML()}
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Next Target Start Date:</td>

                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.nextTargetStartDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Task Duration:</td>

                                            <td valign="top" class="value">
                                                ${taskRecurringScheduleInstance?.taskDuration} ${taskRecurringScheduleInstance?.taskDurationPeriod}
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Next Target Completion Date:</td>

                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.nextTargetCompletionDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                            <div class="buttons">
                                <g:form controller="taskRecurringScheduleDetailed">
                                    <input type="hidden" name="id" value="${taskRecurringScheduleInstance?.id}" />
                                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                    <span class="button"><g:actionSubmit class="go" value="Show" /></span>
                                </g:form>
                            </div>

                        </g:else>
                    </richui:tabContent>
<!-- End Task Recurrence tab -->

<!-- Start Inventory tab -->
                    <richui:tabContent>

                        <g:if test="${inventoryMovementList.isEmpty()}">
                            <br />
                            No Inventory Movements.
                            <br />
                            <br />
                        </g:if>
                        <g:else>
                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Inventory Item</th>
                                            <th>Quantity</th>
                                            <th>Movement Type</th>
                                            <th>Date</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${inventoryMovementList}" status="i" var="inventoryMovementInstance">
                                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                                <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                                    ${fieldValue(bean:inventoryMovementInstance, field:'inventoryItem')}
                                                </td>

                                                <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                                    ${fieldValue(bean:inventoryMovementInstance, field:'quantity')}
                                                </td>

                                                <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                                    ${fieldValue(bean:inventoryMovementInstance, field:'inventoryMovementType')}
                                                </td>

                                                <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                                    <g:formatDate date="${inventoryMovementInstance.date}" format="EEE, dd-MMM-yyyy"/>
                                                </td>

                                                <td class="notClickable">
                                                    <g:link controller="inventoryMovementDetailed" action="show" id="${inventoryMovementInstance.id}">
                                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" title="Show" />
                                                    </g:link>
                                                </td>

                                            </tr>
                                        </g:each>
                                    </tbody>
                                </table>
                            </div>
                        </g:else>

                        <g:form controller="inventoryItemDetailed" >
                            <g:hiddenField name="task.id" value="${taskInstance?.id}" />
                            <div class="buttons">
                                <g:if test="${!inventoryMovementList.isEmpty()}">
                                    Results: ${inventoryMovementList.size()}
                                    <br />
                                </g:if>
                                <span class="button">
                                    <g:actionSubmit action="findInventoryItemForMovement" class="add" value="Add" />
                                </span>
                            </div>
                        </g:form>

                    </richui:tabContent>
<!-- End Inventory tab -->

<!-- Start Sub Task tab -->
                    <richui:tabContent>
                        <g:if test="${subTaskInstanceTotal > 0}">
                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>

                                            <th>Id</th>

                                            <th>Target Start Date</th>

                                            <th>Description</th>

                                            <th>Lead Person</th>

                                            <th>Task Priority</th>

                                            <th>Task Status</th>

                                            <th></th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                    <g:each in="${subTaskInstanceList}" status="i" var="subTaskInstance">
                                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                            <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                                                ${fieldValue(bean:subTaskInstance, field:'id')}
                                            </td>

                                            <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                                                <g:formatDate date="${subTaskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>

                                            <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                                                ${fieldValue(bean:subTaskInstance, field:'description')}
                                            </td>


                                            <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                                                ${fieldValue(bean:subTaskInstance, field:'leadPerson')}
                                            </td>

                                            <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                                                ${fieldValue(bean:subTaskInstance, field:'taskPriority')}
                                            </td>

                                            <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'>
                                                ${fieldValue(bean:subTaskInstance, field:'taskStatus')}
                                            </td>

                                            <td class="notClickable">
                                                <g:link action="show" id="${subTaskInstance.id}">
                                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" title="Show" />
                                                </g:link>
                                            </td>

                                        </tr>
                                    </g:each>
                                    </tbody>
                                </table>
                            </div>

                            <div class="buttons">
                                <g:form>
                                    <g:hiddenField name="id" value="${taskInstance?.id}" />
                                    <g:if test="${subTaskInstanceTotal > subTaskInstanceMax}">
                                        Showing ${subTaskInstanceMax} of ${subTaskInstanceTotal}
                                        <br />
                                    </g:if>
                                    <g:else>
                                        Total ${subTaskInstanceTotal}
                                        <br />
                                    </g:else>
                                    <span class="button"><g:actionSubmit action="listSubTasks" class="table" value="List" /></span>
                                    <span class="button"><g:actionSubmit action="createSubTask" class="save" value="Create" onclick="return confirm('${g.message(code: 'sub.task.create.confirm')}');" /></span>
                                </g:form>
                            </div>

                        </g:if>
                        <g:else>
                            <br />
                            No Sub Tasks.
                            <br />
                            <br />

                            <div class="buttons">
                                <g:form>
                                    <g:hiddenField name="id" value="${taskInstance?.id}" />
                                    <span class="button"><g:actionSubmit action="createSubTask" class="save" value="Create" onclick="return confirm('${g.message(code: 'sub.task.create.confirm')}');" /></span>
                                </g:form>
                            </div>
                        </g:else>

                    </richui:tabContent>
<!-- End Sub Task tab -->

                </richui:tabContents>
            </richui:tabView>

        </div> <!--body-->
    </body>
</html>
