class  InventoryItem {
    InventoryGroup inventoryGroup
    InventoryType inventoryType
    UnitOfMeasure unitOfMeasure
    InventoryLocation inventoryLocation
    Picture picture
    Supplier preferredSupplier
    String name
    String description = ""
    String comment = ""
    BigDecimal estimatedUnitPriceAmount
    Currency estimatedUnitPriceCurrency
    String suppliersPartNumber
    Integer unitsInStock = 0
    Integer reorderPoint = 0
    Integer reorderQuantity = 1
    boolean isActive = true
    boolean isObsolete = false
    boolean enableReorderListing = true

    static mapping = {
        picture cascade: 'all-delete-orphan', lazy: true, inverse: true
    }

    static hasMany = [spareFor: Asset,
                                    inventoryMovements: InventoryMovement,
                                    alternateSuppliers: Supplier]

//     static belongsTo = []

    static constraints = {
        picture(nullable:true)
        name(unique:true, blank:false, maxSize:50)
        description(maxSize:255)
        comment(maxSize:500)
        unitsInStock(min:0)
        unitOfMeasure()
        inventoryLocation()
        inventoryGroup()
        inventoryType()
        isActive()
        isObsolete()
        enableReorderListing()
        reorderPoint(min:0)
        reorderQuantity(min:1)
        estimatedUnitPriceAmount(nullable:true, max: new BigDecimal(1000000000000))
        estimatedUnitPriceCurrency(nullable:true)
        suppliersPartNumber(blank:true, nullable:true, maxSize:50)
        preferredSupplier(nullable:true)
    }

    String toString() {"${this.name}"}

    static searchable = {
        only = ['name', 'description', 'comment', 'isActive', 'isObsolete', 'inventoryLocation', 'inventoryGroup', 'spareFor']
        //name boost: 1.5
        inventoryLocation component: true
        inventoryGroup component: true
        spareFor component: true
    }

    //  This additional setter is used to convert the checkBoxList string or string array
    //  of ids selected to the corresponding domain objects.
    public void setAlternateSuppliersFromCheckBoxList(ids) {
        def idList = []
        if(ids instanceof String) {
                if(ids.isInteger())
                    idList << ids.toLong()
        }
        else {
            ids.each() {
                if(it.isInteger())
                    idList << it.toLong()
            }
        }
        this.alternateSuppliers = idList.collect { Supplier.get( it ) }
    }

    //  This additional setter is used to convert the checkBoxList string or string array
    //  of ids selected to the corresponding domain objects.
    public void setSpareForFromCheckBoxList(ids) {
        def idList = []
        if(ids instanceof String) {
                if(ids.isInteger())
                    idList << ids.toLong()
        }
        else {
            ids.each() {
                if(it.isInteger())
                    idList << it.toLong()
            }
        }
        this.spareFor = idList.collect { Asset.get( it ) }
    }

}
