<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search</title>
        <filterpane:includes />
        <nav:resources override="true"/>
        <export:resource />
        <resource:dateChooser />
        <g:javascript src="taskQuickSearchPane.js" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>

        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>
            <filterpane:currentCriteria domainBean="Task"
                                    action="search"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images"
                                    removeImgFile="bullet_delete.png"
                                    title="Advanced Search"/>

            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                </span>
                Results: ${taskInstanceList.size()} / ${taskInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Advanced" appliedText="Advanced" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post" action="setSearchParamsMax" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
                </g:form>
            </div>

            <br />

            <g:if test="${taskInstanceTotal > taskInstanceList.size()}">
                <div class="paginateButtons">
                    <g:paginate action="search" total="${taskInstanceTotal}" params="${filterParams}" />
                </div>
            </g:if>

            <g:render template="list" />

            <div class="paginateButtons">
                <g:paginate action="search" total="${taskInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="Task"
                                    title="Advanced Search"
                                    action="search"
                                    class="overlayPane"
                                    additionalProperties="id"
                                    excludeProperties="targetCompletionDate"
                                    associatedProperties="taskPriority.name,
                                                                                leadPerson.lastName,
                                                                                leadPerson.firstName,
                                                                                taskGroup.name,
                                                                                highestSeverity.code,
                                                                                primaryAsset.name,
                                                                                taskStatus.name,
                                                                                taskType.name"
                                    filterPropertyValues="${['taskPriority.name':[values: associatedPropertyValues.taskPriorityList],
                                                                                'leadPerson.lastName':[values: associatedPropertyValues.lastNameList],
                                                                                'leadPerson.firstName':[values: associatedPropertyValues.firstNameList],
                                                                                'taskGroup.name':[values: associatedPropertyValues.taskGroupList],
                                                                                'highestSeverity.code':[values: associatedPropertyValues.highestSeverityList],
                                                                                'primaryAsset.name':[values: associatedPropertyValues.assetList],
                                                                                'taskStatus.name':[values: associatedPropertyValues.taskStatusList],
                                                                                'taskType.name':[values: associatedPropertyValues.taskTypeList],
                                                                                targetCompletionDate:[years: associatedPropertyValues.yearRange,precision:'day'],
                                                                                targetStartDate:[years: associatedPropertyValues.yearRange,precision:'day']
                                                                                ]}"/>

            <g:render template="quickSearchPane" />

        </div> <!-- end body  -->
    </body>
</html>
