
function toggleUtil(id) {
    $(id).toggle();
}

function toggleWithImgUtil(id, imageId, openImgUrl, closedImgUrl) {

    $(id).toggle();

    if( $(id).visible() ) {
        $(imageId).src= openImgUrl;
    }
    else {
        $(imageId).src= closedImgUrl;
    }
}

function showUtil(id) {
    Effect.Appear(id,{duration:0.2,queue:'end'});
}

function hideUtil(id) {
    Effect.Fade(id,{duration:0.2,queue:'end'});
}

function toggleWithEffectUtil(id) {
    if( $(id).visible() ) {
        Effect.Fade(id,{duration:0.4,queue:'end'});
    }
    else {
        Effect.Appear(id,{duration:0.4,queue:'end'});
    }
}

function toggleWithImgAndEffectUtil(id, imageId, openImgUrl, closedImgUrl) {

    if( $(id).visible() ) {
        Effect.Fade(id,{duration:0.4,queue:'end'});
        $(imageId).src= closedImgUrl;
    }
    else {
        Effect.Appear(id,{duration:0.4,queue:'end'});
        $(imageId).src= openImgUrl;
    }
}

function textAreaScrollBottom(id) {
    $(id).scrollTop = $(id).scrollHeight;
}

function focusUtil(id) {
    $(id).focus();
}

function enableUtil(id) {
    $(id).disabled = false;
}

function disableUtil(id) {
    $(id).disabled = true;
}

// Looping in reverse is apparently more efficient.
function containsUtil(val, array) {
    var i = array.length;
    while (i--) {
        if (array[i] == val) {
            return true;
        }
    }
    return false;
}

function toggleArrayUtil(idArray) {
    var i = idArray.length;
    while (i--) {
        toggleUtil(idArray[i]);
    }
}

// Loops forwards.
function showArrayUtil(idArray) {
    var len = idArray.length
    var i=0;
    for (i=0; i < len; i++) {
        Effect.Appear(idArray[i],{duration:0.05,queue:'end'});
    }
}

// Loops backwards.
function hideArrayUtil(idArray) {
    var i = idArray.length;
    while (i--) {
        Effect.Fade(idArray[i],{duration:0.05,queue:'end'});
    }
}

function disableArrayUtil(idArray) {
    var i = idArray.length;
    while (i--) {
        disableUtil(idArray[i]);
    }
}

function enableArrayUtil(idArray) {
    var i = idArray.length;
    while (i--) {
        enableUtil(idArray[i]);
    }
}

function toggleIfArrayContainsValueUtil(toggleIds, val, array) {
    if(containsUtil(val, array)) {
        //Effect.multiple(toggleIds, Effect.Appear, {duration:0.4,queue:'end'}); // A little slow, will not go bellow 0.1 per item.
        showArrayUtil(toggleIds);
    }
    else {
        hideArrayUtil(toggleIds);
    }
}

function openWindow(url) {
    window.open(url);
}

function getContextPath() {
    var contextPath = '/' + location.pathname.split('/',2)[1]
    return contextPath
}
