

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit UnitOfMeasure</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">UnitOfMeasure List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New UnitOfMeasure</g:link></span>
        </div>
        <div class="body">
            <h1>Edit UnitOfMeasure</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${unitOfMeasureInstance}">
            <div class="errors">
                <g:renderErrors bean="${unitOfMeasureInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${unitOfMeasureInstance?.id}" />
                <input type="hidden" name="version" value="${unitOfMeasureInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:unitOfMeasureInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:unitOfMeasureInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItems">Inventory Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:unitOfMeasureInstance,field:'inventoryItems','errors')}">
                                    
<ul>
<g:each var="i" in="${unitOfMeasureInstance?.inventoryItems?}">
    <li><g:link controller="inventoryItem" action="show" id="${i.id}">${i?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="inventoryItem" params="['unitOfMeasure.id':unitOfMeasureInstance?.id]" action="create">Add InventoryItem</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:unitOfMeasureInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${unitOfMeasureInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:unitOfMeasureInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:unitOfMeasureInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
