<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show Task</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Task List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Task</g:link></span>
        </div>
        <div class="body">
            <h1>Show Task</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <div class="dialog">
                <table>
                    <tbody>

                    
                        <tr class="prop">
                            <td valign="top" class="name">Id:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'id')}</td>
                            
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Description:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'description')}</td>
                            
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Comment:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'comment')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Target Start Date:</td>
                            
                            <td valign="top" class="value"><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd MMM yyyy"/></td>
                            
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Target Completion Date:</td>
                            
                            <td valign="top" class="value"><g:formatDate date="${taskInstance.targetCompletionDate}" format="EEE, dd MMM yyyy"/></td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Lead Person:</td>
                            
                            <td valign="top" class="value">${taskInstance?.leadPerson?.encodeAsHTML()}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Task Priority:</td>
                            
                            <td valign="top" class="value">${taskInstance?.taskPriority?.encodeAsHTML()}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Task Status:</td>
                            
                            <td valign="top" class="value">${taskInstance?.taskStatus?.encodeAsHTML()}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Is Active:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isActive')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Is Approved:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isApproved')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Is Scheduled:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isScheduled')}</td>
                            
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Parent Task:</td>
                            
                            <td valign="top" class="value"><g:link controller="taskDetailed" action="show" id="${taskInstance?.parentTask?.id}">${taskInstance?.parentTask?.encodeAsHTML()}</g:link></td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Sub Tasks:</td>
                            
                            <td  valign="top" style="text-align:left;" class="value">
                                <ul>
                                <g:each var="s" in="${taskInstance.subTasks}">
                                    <li><g:link controller="taskDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Task Group:</td>
                            
                            <td valign="top" class="value">${taskInstance?.taskGroup?.encodeAsHTML()}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Task Type:</td>
                            
                            <td valign="top" class="value">${taskInstance?.taskType?.encodeAsHTML()}</td>
                            
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">Assigned Persons:</td>
                            
                            <td  valign="top" style="text-align:left;" class="value">
                                <ul>
                                <g:each var="a" in="${taskInstance.assignedPersons}">
                                    <li><g:link controller="assignedPersonDetailed" action="edit" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>
                            </td>
                            
                        </tr>
                    
                    </tbody>
                </table>
            </div>
            <div class="buttons">
                <g:form>
                    <input type="hidden" name="id" value="${taskInstance?.id}" />
                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </g:form>
            </div>

            <div class="list">
                <h1>Faults</h1>
                <table>
                    <thead>
                        <tr>
                            <th>Comment</th>
                            <th>Date Done</th>
                            <th>Duration</th>
                            <th>Entered By</th>
                            <th></th>

<!--                            <g:sortableColumn property="comment" title="Comment" />
                        
                            <g:sortableColumn property="dateDone" title="Date Done" />
                        
                            <g:sortableColumn property="enteredBy" title="Entered By" />-->
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${taskInstance?.entries}" status="i" var="entry">
                        <g:if test="${entry.entryType == EntryType.findByName('Fault')}">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'/>
                            
                                <td style="width:65%">${entry.comment}</td>
                                <td><g:formatDate date="${entry.dateDone}" format="EEE, dd MMM yyyy"/></td>
                                <td>${entry.durationHour}:${entry.durationMinute}</td>
                                <td>${entry.enteredBy}</td>

                                <td>
                                    <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                        <img  src="${createLinkTo(dir:'images/skin',file:'database_edit.png')}" alt="Edit" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:if>
                    </g:each>
                    </tbody>
                </table>
            </div>

            <div class="list">
                <h1>Work Done</h1>
                <table>
                    <thead>
                        <tr>
                            <th>Comment</th>
                            <th>Date Done</th>
                            <th>Duration</th>
                            <th>Entered By</th>
                            <th></th>

<!--                            <g:sortableColumn property="commentW" title="Comment" />
                        
                            <g:sortableColumn property="dateDoneW" title="Date Done" />
                        
                            <g:sortableColumn property="enteredByW" title="Entered By" />-->
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${taskInstance?.entries}" status="i" var="entry">
                        <g:if test="${entry.entryType == EntryType.findByName('WorkDone')}">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'/>

                                <td width="65%">${entry.comment}</td>
                                <td><g:formatDate date="${entry.dateDone}" format="EEE, dd MMM yyyy"/></td>
                                <td>${entry.durationHour}:${entry.durationMinute}</td>
                                <td>${entry.enteredBy}</td>

                                <td>
                                    <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                        <img  src="${createLinkTo(dir:'images/skin',file:'database_edit.png')}" alt="Edit" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:if>
                    </g:each>
                    </tbody>
                </table>
            </div>

            <br />

            <div class="buttons">
                <g:form controller="entryDetailed">
                    <input type="hidden" name="taskInstance.id" value="${taskInstance?.id}" />
                    <span class="button">
                        <g:actionSubmit value="Add Entry" action="create"  class="add"/>
                    </span>
                </g:form>
            </div>

        </div>
    </body>
</html>
