

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit RecurringSchedule</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">RecurringSchedule List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New RecurringSchedule</g:link></span>
        </div>
        <div class="body">
            <h1>Edit RecurringSchedule</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${recurringScheduleInstance}">
            <div class="errors">
                <g:renderErrors bean="${recurringScheduleInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${recurringScheduleInstance?.id}" />
                <input type="hidden" name="version" value="${recurringScheduleInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="plannedMaintenance">Planned Maintenance:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:recurringScheduleInstance,field:'plannedMaintenance','errors')}">
                                    <g:select optionKey="id" from="${PlannedMaintenance.list()}" name="plannedMaintenance.id" value="${recurringScheduleInstance?.plannedMaintenance?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:recurringScheduleInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${recurringScheduleInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="period">Period:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:recurringScheduleInstance,field:'period','errors')}">
                                    <g:select optionKey="id" from="${Period.list()}" name="period.id" value="${recurringScheduleInstance?.period?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recurEvery">Recur Every:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:recurringScheduleInstance,field:'recurEvery','errors')}">
                                    <input type="text" id="recurEvery" name="recurEvery" value="${fieldValue(bean:recurringScheduleInstance,field:'recurEvery')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="startDate">Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:recurringScheduleInstance,field:'startDate','errors')}">
                                    <g:datePicker name="startDate" value="${recurringScheduleInstance?.startDate}" precision="day" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:recurringScheduleInstance,field:'task','errors')}">
                                    <g:select optionKey="id" from="${Task.list()}" name="task.id" value="${recurringScheduleInstance?.task?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
