import grails.util.GrailsUtil

class BootStrap 
{
    //Required to be right here for Acegi plugin.
    def authenticateService
    Boolean BootStrapDemoDataSuccessful = true

    def init = { servletContext ->

    println "**** BootStrap GrailsUtil.environment = ${GrailsUtil.environment}"
    
        switch (GrailsUtil.environment)
        {
            case "development":
                        bootStrapDemoData()
                        break
            case "test":
                        break
            case "production":
                        bootStrapDemoData()
                        break 
        }
    
    }

    def destroy = {
    }

    //Insert some demo/startup data.
    void bootStrapDemoData()
    {
        println "BootStrapping demo data..."
        3.times{println it}

/***********************
START OF UTILITIES
***********************/

//Site
        def siteInstance

        siteInstance = new Site(name: "Creek Mill")
        BootStrapSaveAndTest(siteInstance)

        siteInstance = new Site(name: "Jasper Street Depot")
        BootStrapSaveAndTest(siteInstance)

//UnitOfMeasure
        def unitOfMeasureInstance

        //UnitOfMeasure #1
        unitOfMeasureInstance = new UnitOfMeasure(name: "each")
        BootStrapSaveAndTest(unitOfMeasureInstance)

        //UnitOfMeasure #2
        unitOfMeasureInstance = new UnitOfMeasure(name: "meter(s)")
        BootStrapSaveAndTest(unitOfMeasureInstance)

        //UnitOfMeasure #3
        unitOfMeasureInstance = new UnitOfMeasure(name: "box(es)")
        BootStrapSaveAndTest(unitOfMeasureInstance)

        //UnitOfMeasure #4
        unitOfMeasureInstance = new UnitOfMeasure(name: "litre(s)")
        BootStrapSaveAndTest(unitOfMeasureInstance)

        //UnitOfMeasure #5
        unitOfMeasureInstance = new UnitOfMeasure(name: "kilogram(s)")
        BootStrapSaveAndTest(unitOfMeasureInstance)

//Period
        def periodInstance

        //Period #1
        periodInstance = new Period(period: "Day(s)")
        BootStrapSaveAndTest(periodInstance)

        //Period #2
        periodInstance = new Period(period: "Week(s)")
        BootStrapSaveAndTest(periodInstance)

        //Period #3
        periodInstance = new Period(period: "Month(s)")
        BootStrapSaveAndTest(periodInstance)

        //Period #4
        periodInstance = new Period(period: "Year(s)")
        BootStrapSaveAndTest(periodInstance)

/*********************
START OF PERSON
*********************/

//TypeOfPersonGroup
	def personGroupTypeInstance
        personGroupTypeInstance = new PersonGroupType(name:"Department")
	BootStrapSaveAndTest(personGroupTypeInstance)
        personGroupTypeInstance = new PersonGroupType(name:"Contractor")
	BootStrapSaveAndTest(personGroupTypeInstance)
        personGroupTypeInstance = new PersonGroupType(name:"ProjectTeam")
	BootStrapSaveAndTest(personGroupTypeInstance)
    
//PersonGroup
	def personGroupInstance
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Electrical")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Mechanical")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.findByName("Department"),
                        name:"Production")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.get(2),
                        name:"Kewl AirCon Guys")
	BootStrapSaveAndTest(personGroupInstance)
        personGroupInstance = new PersonGroup(personGroupType:PersonGroupType.get(3),
                        name:"gnuMims")
	BootStrapSaveAndTest(personGroupInstance)

//Authority
        def authInstance

        authInstance = new Authority(description:"Application Admin, not required for daily use! Grants full admin access to the application.",
                                        authority:"ROLE_AppAdmin")
        BootStrapSaveAndTest(authInstance)

        authInstance = new Authority(description:"Business manager, grants full management access.",
                                        authority:"ROLE_Manager")
        BootStrapSaveAndTest(authInstance)

        authInstance = new Authority(description:"Application User, all application users need this base role to allow login.",
                                        authority:"ROLE_AppUser")
        BootStrapSaveAndTest(authInstance)
            
//Person
        def passClearText = "pass"
        def passwordEncoded = authenticateService.encodePassword(passClearText)
        def personInstance

        //Person #1
        personInstance = new Person(loginName:"admin",
                                    firstName:"Admin",
                                    lastName:"Powers",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"admin@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(1))
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("gnuMims"))

        //Person #2
        personInstance = new Person(loginName:"manager",
                                    firstName:"Meca",
                                    lastName:"Manager",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"manager@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(2))
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("gnuMims"))

        //Person #3
        personInstance = new Person(loginName:"user",
                                    firstName:"Demo",
                                    lastName:"User",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("Electrical"))

        //Person #4
        personInstance = new Person(loginName:"craig",
                                    firstName:"Craig",
                                    lastName:"SuperSparky",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("Electrical"))

        //Person #5
        personInstance = new Person(loginName:"john",
                                    firstName:"John",
                                    lastName:"SuperFitter",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("Mechanical"))

        //Person #6
        personInstance = new Person(loginName:"mann",
                                    firstName:"Production",
                                    lastName:"Mann",
                                    pass:passClearText,
                                    password:passwordEncoded,
                                    email:"user@example.com")
        BootStrapSaveAndTest(personInstance)
        personInstance.addToAuthorities(Authority.get(3))
        personInstance.addToPersonGroups(PersonGroup.findByName("Production"))

/*********************
START OF TASK
*********************/

//TaskGroup
        def taskGroupInstance

        taskGroupInstance = new TaskGroup(name:"Engineering Activites",
                                                                            description:"Engineering daily activities")
        BootStrapSaveAndTest(taskGroupInstance)

        taskGroupInstance = new TaskGroup(name:"Production Activites",
                                                                            description:"Production daily activities")
        BootStrapSaveAndTest(taskGroupInstance)

        taskGroupInstance = new TaskGroup(name:"New Projects",
                                                                            description:" ")
        BootStrapSaveAndTest(taskGroupInstance)

//TaskStatus
        def taskStatusInstance
    
        taskStatusInstance = new TaskStatus(name:"Not Started")
        BootStrapSaveAndTest(taskStatusInstance)

        taskStatusInstance = new TaskStatus(name:"In Progress")
        BootStrapSaveAndTest(taskStatusInstance)

        taskStatusInstance = new TaskStatus(name:"Completed")
        BootStrapSaveAndTest(taskStatusInstance)

//TaskPriority
        def taskPriorityInstance

        taskPriorityInstance = new TaskPriority(name:"Normal")
        BootStrapSaveAndTest(taskPriorityInstance)

        taskPriorityInstance = new TaskPriority(name:"Low")
        BootStrapSaveAndTest(taskPriorityInstance)

        taskPriorityInstance = new TaskPriority(name:"High")
        BootStrapSaveAndTest(taskPriorityInstance)

        taskPriorityInstance = new TaskPriority(name:"Immediate")
        BootStrapSaveAndTest(taskPriorityInstance)

//TaskType
        def taskTypeInstance

        taskTypeInstance = new TaskType(name:"Unscheduled Breakin")
        BootStrapSaveAndTest(taskTypeInstance)

        taskTypeInstance = new TaskType(name:"Preventative Maintenance")
        BootStrapSaveAndTest(taskTypeInstance)

        taskTypeInstance = new TaskType(name:"Project")
        BootStrapSaveAndTest(taskTypeInstance)

        taskTypeInstance = new TaskType(name:"Turnaround")
        BootStrapSaveAndTest(taskTypeInstance)

        taskTypeInstance = new TaskType(name:"Production Run")
        BootStrapSaveAndTest(taskTypeInstance)

//Task
        def taskInstance

        //Task #1
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 taskPriority:TaskPriority.get(2),
                 taskType:TaskType.get(1),
                 leadPerson:Person.get(3),
                 description:"Check specific level sensor",
                 comment:"Has been noted as problematic, try recalibrating.")
        BootStrapSaveAndTest(taskInstance)

        //Task #2
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                taskStatus:TaskStatus.findByName("Not Started"),
                taskPriority:TaskPriority.get(2),
                taskType:TaskType.get(1),
                leadPerson:Person.get(5),
                description:"Some follow-up work",
                comment:"Some help required",
                parentTask: Task.get(1))
        BootStrapSaveAndTest(taskInstance)

        //Task #3
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                taskStatus:TaskStatus.findByName("Not Started"),
                taskPriority:TaskPriority.get(2),
                taskType:TaskType.get(1),
                leadPerson:Person.get(5),
                description:"A Sub Task can be created by setting the Parent Task value",
                comment:"Some help required",
                parentTask: Task.get(1))
        BootStrapSaveAndTest(taskInstance)

        //Task #4
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Engineering Activites"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 taskPriority:TaskPriority.get(2),
                 taskType:TaskType.get(1),
                 leadPerson:Person.get(4),
                 description:"Replace sensor at next opportunity.",
                 comment:"Nothing else has worked.",
                parentTask: Task.get(1))
        BootStrapSaveAndTest(taskInstance)

        //Task #5
        taskInstance = new Task(taskGroup:TaskGroup.findByName("Production Activites"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 taskPriority:TaskPriority.get(2),
                 taskType:TaskType.get(5),
                 leadPerson:Person.get(6),
                 description:"Production Report",
                 comment:"Production report for specific production run or shift")
        BootStrapSaveAndTest(taskInstance)

        //Task #6
        taskInstance = new Task(taskGroup:TaskGroup.findByName("New Projects"),
                 taskStatus:TaskStatus.findByName("Not Started"),
                 taskPriority:TaskPriority.get(2),
                 taskType:TaskType.get(3),
                 leadPerson:Person.get(1),
                 description:"Make killer CMMS app",
                 comment:"Use Grails and get a move on!")
        BootStrapSaveAndTest(taskInstance)

//EntryType
        def entryTypeInstance

        entryTypeInstance = new EntryType(name:"Fault")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"WorkDone")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"Production Note")
        BootStrapSaveAndTest(entryTypeInstance)

        entryTypeInstance = new EntryType(name:"Work Request")
        BootStrapSaveAndTest(entryTypeInstance)

//Entry
        def entryInstance

        //Entry #1
        entryInstance = new Entry(enteredBy: Person.get(3),
                                                    task: Task.get(1),
                                                    entryType: EntryType.findByName("Fault"),
                                                    comment: "This level sensor is causing us trouble.",
                                                    durationMinute: 20)
        BootStrapSaveAndTest(entryInstance)

        //Entry #2
        entryInstance = new Entry(enteredBy: Person.get(4),
                                                    task: Task.get(1),
                                                    entryType: EntryType.findByName("WorkDone"),
                                                    comment: "Cleaned sensor, see how it goes.",
                                                    durationMinute: 30)
        BootStrapSaveAndTest(entryInstance)

        //Entry #3
        entryInstance = new Entry(enteredBy: Person.get(4),
                                                    task: Task.get(1),
                                                    entryType: EntryType.findByName("WorkDone"),
                                                    comment: "Checked up on it later and sensor is dropping out intermittently, created subTask to replace sensor.",
                                                    durationMinute: 20)
        BootStrapSaveAndTest(entryInstance)

//ModificationType
        def taskModificationTypeInstance
        taskModificationTypeInstance = new TaskModificationType(name:"Created").save()
        taskModificationTypeInstance = new TaskModificationType(name:"Completed").save()
        taskModificationTypeInstance = new TaskModificationType(name:"Closed").save()
        taskModificationTypeInstance = new TaskModificationType(name:"Altered").save()
        taskModificationTypeInstance = new TaskModificationType(name:"TargetDateModified").save()
        taskModificationTypeInstance = new TaskModificationType(name:"ScheduledDateModified").save()
        taskModificationTypeInstance = new TaskModificationType(name:"DescriptionModified").save()
        taskModificationTypeInstance = new TaskModificationType(name:"AssignedToModified").save()
        taskModificationTypeInstance = new TaskModificationType(name:"NameModified").save()
    
//AssignedPerson
        def assignedPersonInstance

        //AssignedPerson #1
        assignedPersonInstance = new AssignedPerson(person: Person.get(4),
                                                                                        task: Task.get(1),
                                                                                        estimatedHour: 1,
                                                                                        estimatedMinute: 20)
        BootStrapSaveAndTest(assignedPersonInstance)

        //AssignedPerson #2
        assignedPersonInstance = new AssignedPerson(person: Person.get(5),
                                                                                        task: Task.get(1),
                                                                                        estimatedHour: 3,
                                                                                        estimatedMinute: 30)
        BootStrapSaveAndTest(assignedPersonInstance)

//TaskRecurringSchedule
        def taskRecurringScheduleInstance

        //TaskRecurringSchedule #1
        taskRecurringScheduleInstance = new TaskRecurringSchedule(task: Task.get(1),
                                                                                                    recurEvery: 1,
                                                                                                    recurPeriod: Period.get(1),
                                                                                                    startDate: new Date(),
                                                                                                    generateAhead: 1,
                                                                                                    generateAheadPeriod: Period.get(1),
                                                                                                    taskDuration: 1,
                                                                                                    taskDurationPeriod: Period.get(1))
        BootStrapSaveAndTest(taskRecurringScheduleInstance)

        //TaskRecurringSchedule #2
        taskRecurringScheduleInstance = new TaskRecurringSchedule(task: Task.get(2),
                                                                                                    recurEvery: 1,
                                                                                                    recurPeriod: Period.get(1),
                                                                                                    startDate: new Date(),
                                                                                                    generateAhead: 1,
                                                                                                    generateAheadPeriod: Period.get(1),
                                                                                                    taskDuration: 1,
                                                                                                    taskDurationPeriod: Period.get(1))
        BootStrapSaveAndTest(taskRecurringScheduleInstance)

/*************************
START OF INVENTORY
**************************/

//InventoryStore
        def inventoryStoreInstance

        inventoryStoreInstance = new InventoryStore(site: Site.get(1), name: "Store #1")
        BootStrapSaveAndTest(inventoryStoreInstance)

        inventoryStoreInstance = new InventoryStore(site: Site.get(2), name: "Store #2")
        BootStrapSaveAndTest(inventoryStoreInstance)

//StoreLocation
        def storeLocation
        
        storeLocation = new StoreLocation(inventoryStore: InventoryStore.get(1), bin: "A1-2")
        BootStrapSaveAndTest(storeLocation)

        storeLocation = new StoreLocation(inventoryStore: InventoryStore.get(1), bin: "C55")
        BootStrapSaveAndTest(storeLocation)

//InventoryGroup
        def inventoryGroupInstance

        //InventoryGroup #1
        inventoryGroupInstance = new InventoryGroup(name: "Misc")
        BootStrapSaveAndTest(inventoryGroupInstance)

        //InventoryGroup #2
        inventoryGroupInstance = new InventoryGroup(name: "Electrical")
        BootStrapSaveAndTest(inventoryGroupInstance)

        //InventoryGroup #3
        inventoryGroupInstance = new InventoryGroup(name: "Mechanical")
        BootStrapSaveAndTest(inventoryGroupInstance)

        //InventoryGroup #4
        inventoryGroupInstance = new InventoryGroup(name: "Production")
        BootStrapSaveAndTest(inventoryGroupInstance)

//InventoryType
        def inventoryTypeInstance

        inventoryTypeInstance = new InventoryType(name: "Consumable")
        BootStrapSaveAndTest(inventoryTypeInstance)

        inventoryTypeInstance = new InventoryType(name: "Repairable")
        BootStrapSaveAndTest(inventoryTypeInstance)

//InventoryItem
        def inventoryItemInstance

        //InventoryItem #1
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(1),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(2),
                                                                                    name: "J-Rope",
                                                                                    description: "Twine wound J-Rope",
                                                                                    reorderPoint: 0)
        BootStrapSaveAndTest(inventoryItemInstance)

        //InventoryItem #2
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(1),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(2),
                                                                                    name: "L-Rope",
                                                                                    description: "Twine wound L-Rope",
                                                                                    alternateItems: InventoryItem.get(1),
                                                                                    reorderPoint: 0)
        BootStrapSaveAndTest(inventoryItemInstance)

        //InventoryItem #3
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(3),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(1),
                                                                                    name: "2305-2RS",
                                                                                    description: "Bearing 25x62x24mm double row self aligning ball",
                                                                                    reorderPoint: 2)
        BootStrapSaveAndTest(inventoryItemInstance)

        //InventoryItem #4
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(2),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(1),
                                                                                    name: "L1592-K10",
                                                                                    description: "10kW contactor",
                                                                                    reorderPoint: 0)
        BootStrapSaveAndTest(inventoryItemInstance)

        //InventoryItem #5
        inventoryItemInstance = new InventoryItem(inventoryGroup: InventoryGroup.get(3),
                                                                                    inventoryType: InventoryType.get(1),
                                                                                    unitOfMeasure: UnitOfMeasure.get(1),
                                                                                    name: "6205-ZZ",
                                                                                    description: "Bearing 25x52x15mm single row ball shielded",
                                                                                    reorderPoint: 2)
        BootStrapSaveAndTest(inventoryItemInstance)

//StoredItem
        def storedItemInstance

        //StoredItem #1
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(1),
                                                                            storeLocation: StoreLocation.get(1),
                                                                            quantity: 8)
        BootStrapSaveAndTest(storedItemInstance)

        //StoredItem #2
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(1),
                                                                            storeLocation: StoreLocation.get(2),
                                                                            quantity: 4)
        BootStrapSaveAndTest(storedItemInstance)

        //StoredItem #3
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(2),
                                                                            storeLocation: StoreLocation.get(1),
                                                                            quantity: 2)
        BootStrapSaveAndTest(storedItemInstance)

        //StoredItem #4
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(3),
                                                                            storeLocation: StoreLocation.get(1),
                                                                            quantity: 2)
        BootStrapSaveAndTest(storedItemInstance)

        //StoredItem #5
        storedItemInstance = new StoredItem(inventoryItem: InventoryItem.get(4),
                                                                            storeLocation: StoreLocation.get(1),
                                                                            quantity: 30)
        BootStrapSaveAndTest(storedItemInstance)

/*******************
START OF ASSET
*******************/

//LifePlan
        def lifeplanInstance

        lifeplanInstance = new LifePlan(name: "Initial Plan")
        BootStrapSaveAndTest(lifeplanInstance)

//MaintenancePolicy
        def maintenancePolicyInstance

        //MaintenancePolicy #1
        maintenancePolicyInstance = new MaintenancePolicy(name: "Fixed Time")
        BootStrapSaveAndTest(maintenancePolicyInstance)

        //MaintenancePolicy #2
        maintenancePolicyInstance = new MaintenancePolicy(name: "Condition Based Online")
        BootStrapSaveAndTest(maintenancePolicyInstance)

        //MaintenancePolicy #3
        maintenancePolicyInstance = new MaintenancePolicy(name: "Condition Based Offline")
        BootStrapSaveAndTest(maintenancePolicyInstance)

        //MaintenancePolicy #4
        maintenancePolicyInstance = new MaintenancePolicy(name: "Design Out")
        BootStrapSaveAndTest(maintenancePolicyInstance)

        //MaintenancePolicy #5
        maintenancePolicyInstance = new MaintenancePolicy(name: "Operate To Failure")
        BootStrapSaveAndTest(maintenancePolicyInstance)

//TaskProcedure
        def taskProcedureInstance

        taskProcedureInstance = new TaskProcedure(name: "Daily check")
        BootStrapSaveAndTest(taskProcedureInstance)
        taskProcedureInstance.addToTasks(Task.get(1))

//MaintenanceAction
        def maintenanceActionInstance

        //MaintenanceAction #1
        maintenanceActionInstance = new MaintenanceAction(description: "Check all E-stops, activate E-stops S1-S12 and ensure machine cannot run",
                                                                                                        procedureStepNumber: 1,
                                                                                                        maintenancePolicy: MaintenancePolicy.get(1),
                                                                                                        taskProcedure: TaskProcedure.get(1))
        BootStrapSaveAndTest(maintenanceActionInstance)

        //MaintenanceAction #2
        maintenanceActionInstance = new MaintenanceAction(description: "Do more pushups",
                                                                                                        procedureStepNumber: 2,
                                                                                                        maintenancePolicy: MaintenancePolicy.get(1),
                                                                                                        taskProcedure: TaskProcedure.get(1))
        BootStrapSaveAndTest(maintenanceActionInstance)

        //MaintenanceAction #3
        maintenanceActionInstance = new MaintenanceAction(description: "Ok just one more pushup",
                                                                                                        procedureStepNumber: 3,
                                                                                                        maintenancePolicy: MaintenancePolicy.get(1),
                                                                                                        taskProcedure: TaskProcedure.get(1))
        BootStrapSaveAndTest(maintenanceActionInstance)
                                                                                                    
//SystemSection
    def systemSectionInstance

    //SystemSection #1
    systemSectionInstance = new SystemSection(name: "Press Section",
                                                                                   site: Site.get(1))
    BootStrapSaveAndTest(systemSectionInstance)

    //SystemSection #2
    systemSectionInstance = new SystemSection(name: "RO System",
                                                                                   site: Site.get(2))
    BootStrapSaveAndTest(systemSectionInstance)

    //SystemSection #3
    systemSectionInstance = new SystemSection(name: "Auxilliray Section",
                                                                                   site: Site.get(1))
    BootStrapSaveAndTest(systemSectionInstance)

//AssetType
        def assetTypeInstance

        //AssetType #1
        assetTypeInstance = new AssetType(name: "Print Unit")
        BootStrapSaveAndTest(assetTypeInstance)

        //AssetType #2
        assetTypeInstance = new AssetType(name: "Reactor Tower")
        BootStrapSaveAndTest(assetTypeInstance)
    
//Assembly
        def assemblyInstance

        //Assembly #1
        assemblyInstance = new Assembly(name: "Print Couple",
                                                                        assetType: AssetType.get(1))
        BootStrapSaveAndTest(assemblyInstance)
//        assemblyInstance.addToMaintenanceActions(MaintenanceAction.get(1))
        
        //Assembly #2
        assemblyInstance = new Assembly(name: "Agitator",
                                                                        assetType: AssetType.get(2))
        BootStrapSaveAndTest(assemblyInstance)

//SubAssembly
        def subAssemblyInstance

        //SubAssembly #1
        subAssemblyInstance = new SubAssembly(name: "Cylinder",
                                                                                    assembly: Assembly.get(1))
        BootStrapSaveAndTest(subAssemblyInstance)
 
         //SubAssembly #2
        subAssemblyInstance = new SubAssembly(name: "Gearmotor",
                                                                                    assembly: Assembly.get(2))
        BootStrapSaveAndTest(subAssemblyInstance)

//ComponentItem
        def componentItemInstance
    
        //ComponentItem #1
        componentItemInstance = new ComponentItem(name: "Bearing",
                                                                                            subAssembly: SubAssembly.get(1))
        BootStrapSaveAndTest(componentItemInstance)

         //ComponentItem #2
        componentItemInstance = new ComponentItem(name: "Drive shaft oil seal",
                                                                                            subAssembly: SubAssembly.get(2))
        BootStrapSaveAndTest(componentItemInstance)

//Asset
        def assetInstance

        //Asset #1
        assetInstance = new Asset(name: "Print Unit 22",
                                                        assetType: AssetType.get(1),
                                                        systemSection: SystemSection.get(1))
        BootStrapSaveAndTest(assetInstance)
//        assetInstance.addToMaintenanceActions(MaintenanceAction.get(1))

        //Asset #2
        assetInstance = new Asset(name: "Print Unit 21",
                                                        assetType: AssetType.get(1),
                                                        systemSection: SystemSection.get(1))
        BootStrapSaveAndTest(assetInstance)

        //Asset #3
        assetInstance = new Asset(name: "Print Unit 23",
                                                        assetType: AssetType.get(1),
                                                        systemSection: SystemSection.get(1))
        BootStrapSaveAndTest(assetInstance)

        //Asset #4
        assetInstance = new Asset(name: "RO 1",
                                                        assetType: AssetType.get(2),
                                                        systemSection: SystemSection.get(2))
        BootStrapSaveAndTest(assetInstance)

//AssetExtendedAttributeType
        def assetExtendedAttributeInstanceType

        //AssetExtendedAttributeType #1
        assetExtendedAttributeInstanceType = new AssetExtendedAttributeType(name: "Model Number")
        BootStrapSaveAndTest(assetExtendedAttributeInstanceType)

        //AssetExtendedAttributeType #2
        assetExtendedAttributeInstanceType = new AssetExtendedAttributeType(name: "Purchase Cost")
        BootStrapSaveAndTest(assetExtendedAttributeInstanceType)

        //AssetExtendedAttributeType #3
        assetExtendedAttributeInstanceType = new AssetExtendedAttributeType(name: "Serial Number")
        BootStrapSaveAndTest(assetExtendedAttributeInstanceType)

        //AssetExtendedAttributeType #4
        assetExtendedAttributeInstanceType = new AssetExtendedAttributeType(name: "Manufactured Date")
        BootStrapSaveAndTest(assetExtendedAttributeInstanceType)

        //AssetExtendedAttributeType #5
        assetExtendedAttributeInstanceType = new AssetExtendedAttributeType(name: "Location Description")
        BootStrapSaveAndTest(assetExtendedAttributeInstanceType)

//AssetExtendedAttribute
        def assetExtendedAttributeInstance

        //AssetExtendedAttribute #1
        assetExtendedAttributeInstance = new AssetExtendedAttribute(value: "PU Mark 2",
                                                                                                                    asset: Asset.get(1),
                                                                                                                    assetExtendedAttributeType: AssetExtendedAttributeType.get(1))
        BootStrapSaveAndTest(assetExtendedAttributeInstance)

        //AssetExtendedAttribute #2
        assetExtendedAttributeInstance = new AssetExtendedAttribute(value: "On the far side of Tank 5",
                                                                                                                    asset: Asset.get(1),
                                                                                                                    assetExtendedAttributeType: AssetExtendedAttributeType.get(5))
        BootStrapSaveAndTest(assetExtendedAttributeInstance)

/*************************
Finally did it all work. 
**************************/       
        if(BootStrapDemoDataSuccessful) {
            println "BootStrapping demo data...successful."
        }
        else println "BootStrapping demo data...failed."
    }

/****************************************
Call this function instead of .save()
*****************************************/    
    void BootStrapSaveAndTest(object) {
        if(!object.save()) {
            BootStrapDemoDataSuccessful = false
            println "'${object}' failed to save!"
            println object.errors

        }
    } 
}
