<head>
	<meta name="layout" content="main" />
	<title>Edit Person</title>
    <nav:resources override="true"/>
</head>

<body>

	<div class="nav">
        <nav:renderSubItems group="navAlt"/>
	</div>

	<div class="body">
		<g:if test="${flash.message}">
		<div class="message">${flash.message}</div>
		</g:if>
		<g:hasErrors bean="${person}">
		<div class="errors">
			<g:renderErrors bean="${person}" as="list" />
		</div>
		</g:hasErrors>

<!--		<div class="prop">
			<span class="name">ID: ${person.id}</span>
		</div>-->

		<g:form>
			<input type="hidden" name="id" value="${person.id}" />
			<input type="hidden" name="version" value="${person.version}" />
            <input type="hidden" name="password" value="${person.password}" />
			<div class="dialog">
				<table>
				<tbody>

					<tr class="prop">
						<td valign="top" class="name"><label for="loginName">Login Name:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'loginName','errors')}">
							<input type="text" id="loginName" name="loginName" value="${person.loginName?.encodeAsHTML()}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="firstName">First Name:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'firstName','errors')}">
							<input type="text" id="firstName" name="firstName" value="${person.firstName?.encodeAsHTML()}"/>
						</td>
					</tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="lastName">Last Name:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'lastName','errors')}">
                            <input type="text" id="lastName" name="lastName" value="${person.lastName?.encodeAsHTML()}"/>
                        </td>
                    </tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="pass">Password:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'pass','errors')}">
							<input type="password" id="pass" name="pass"  value="${person.pass?.encodeAsHTML()}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="isActive">isActive:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'isActive','errors')}">
							<g:checkBox name="isActive" value="${person.isActive}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="description">Description:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'description','errors')}">
							<input type="text" id="description" name="description" value="${person.description?.encodeAsHTML()}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="email">Email:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'email','errors')}">
							<input type="text" id="email" name="email" value="${person?.email?.encodeAsHTML()}"/>
						</td>
					</tr>

					<tr class="prop">
						<td valign="top" class="name"><label for="emailShow">Show Email:</label></td>
						<td valign="top" class="value ${hasErrors(bean:person,field:'emailShow','errors')}">
							<g:checkBox name="emailShow" value="${person.emailShow}"/>
						</td>
					</tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="employeeID">employee ID:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'employeeID','errors')}">
                            <input type="text" id="employeeID" name="employeeID" value="${person.employeeID?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name" align="left">Authorities:</td>
                    </tr>

                    <g:each var="entry" in="${roleMap}">
                    <tr>
                        <td valign="top" class="name" align="left">${entry.key.authority.encodeAsHTML()}</td>
                        <td align="left"><g:checkBox name="${entry.key.authority}" value="${entry.value}"/></td>
                    </tr>
                    </g:each>

				</tbody>
				</table>
			</div>

			<div class="buttons">
				<span class="button"><g:actionSubmit class="save" value="Update" /></span>
				<span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
			</div>

		</g:form>

	</div>
</body>
