dataSource {
    pooled = true
    /** HSQLDB  */
    driverClassName = "org.hsqldb.jdbcDriver"
    username = "sa"
    password = ""
    /** MySQL */
//     driverClassName = "com.mysql.jdbc.Driver"
//     username = "gnumimsadmin"
//     password = "gnumimsadmin"
}
hibernate {
    cache.use_second_level_cache=true
    cache.use_query_cache=true
    cache.provider_class='com.opensymphony.oscache.hibernate.OSCacheProvider'
}

// Environment specific settings.
// create-drop:  drop tables and data between sessions, then call Bootstrap.
// create:        drop data between sessions, can't explain the rest of the behaviour.
// update:       keep data, update tables as required, then call BootStrap.
environments {
    development {
        dataSource {
            /** HSQLDB - In memory */
            dbCreate = "create-drop"
            url = "jdbc:hsqldb:mem:devDB"
            /** MySQL */
//             dbCreate = "create-drop"
//             url = "jdbc:mysql://host:3306/gnumims_dev"
        }
    }
    test {
        dataSource {
            /** HSQLDB - In memory */
            dbCreate = "update"
            url = "jdbc:hsqldb:mem:devDb"
            /** MySQL */
//             dbCreate = "update"
//             url = "jdbc:mysql://host:3306/gnumims_test"
        }
    }
    production {
        dataSource {
            /** HSQLDB - In memory */
            //Delete dbCreate line after setup!
            dbCreate = "create-drop"
            url = "jdbc:hsqldb:mem:devDB"
            /** HSQLDB - In file */
//             dbCreate = "update"
//             url = "jdbc:hsqldb:file:prodDb;shutdown=true"
            /** MySQL */
//             dbCreate = "update"
//             url = "jdbc:mysql://host:3306/gnumims_prod"
        }
    }
}