import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AppCoreController extends BaseController {

    def authenticateService
    def createDataService

    def index = { redirect(action:start,params:params) }

    // the delete, save and update actions only accept POST requests
    //def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    /**
    * This is where we arrive after login.
    *  Attach the welcome flash message and redirect to where ever we want the user to start.
    * e.g. redirect(controller:"taskDetailed", action:"search")
    */
    def welcome = {
        def personInstance = Person.get(authenticateService.userDomain().id)
        flash.message = "Welcome, ${personInstance.firstName} ${personInstance.lastName}."

        def sess = getSession()
        sess.setMaxInactiveInterval(personInstance.sessionTimeout)
        redirect(action:start)
    }

    def start = {
    }

    def changeSessionTimeout = {
        if (request.method == 'GET') {
            def personInstance = Person.get(authenticateService.userDomain().id)
            return [ personInstance : personInstance ]       
        }
        if (request.method == 'POST') {
            def personInstance = Person.get(authenticateService.userDomain().id)
                personInstance.properties = params
                if (!personInstance.hasErrors() && personInstance.save()) {
                    def sess = getSession()
                    sess.setMaxInactiveInterval(personInstance.sessionTimeout)
                    flash.message = "Session timeout changed."
                    redirect(action:start)
                }
                else {
                    render(view:'changeSessionTimeout',model:[personInstance:personInstance])
                }
        }
    }

    def changePassword = {
        //def principal = authenticateService.principal()
        //println principal.getAuthorities()

        if (request.method == 'GET') {
            def personInstance = Person.get(authenticateService.userDomain().id)
            return [ personInstance : personInstance ]       
        }  

        if (request.method == 'POST') {
            def personInstance = Person.get(authenticateService.userDomain().id)

            if(params.confirmPass == params.pass) {
                personInstance.pass = params.pass
                personInstance.password = authenticateService.encodePassword(personInstance.pass)

                if (!personInstance.hasErrors() && personInstance.save()) {
                    //userCache.removeUserFromCache(personInstance.loginName)
                    flash.message = "Password changed successfully."
                    redirect(action:start)
                }
                else {
                    render(view:'changePassword',model:[personInstance:personInstance])
                }
            }
            else {
                personInstance.errors.reject('person.pass.doesNotMatch',            // Error code, see grails-app/i18n/message.properties
                                                                ['pass', 'class Person'].toArray(),      // Groovy ListArray cast to Object[]
                                                                 '[NothingUseMessageProperites]')  // Default mapping string.
                render(view:'changePassword',model:[personInstance:personInstance])
            }

        }
    }

    @Secured(['ROLE_Manager','ROLE_AppAdmin'])
    def manager = {
    }

    @Secured(['ROLE_AppAdmin'])
    def appAdmin = {
    }

    @Secured(['ROLE_AppAdmin'])
    def createBaseData = {
        createDataService.createBaseData()
        redirect(action:appAdmin)
    }

    @Secured(['ROLE_AppAdmin'])
    def createDemoData = {
        createDataService.createDemoData()
        redirect(action:appAdmin)
    }

}