

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit ComponentItem</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${resource(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">ComponentItem List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New ComponentItem</g:link></span>
        </div>
        <div class="body">
            <h1>Edit ComponentItem</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${componentItemInstance}">
            <div class="errors">
                <g:renderErrors bean="${componentItemInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${componentItemInstance?.id}" />
                <input type="hidden" name="version" value="${componentItemInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:componentItemInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:componentItemInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:componentItemInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${componentItemInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenanceActions">Maintenance Actions:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:componentItemInstance,field:'maintenanceActions','errors')}">
                                    
<ul>
<g:each var="m" in="${componentItemInstance?.maintenanceActions?}">
    <li><g:link controller="maintenanceAction" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="maintenanceAction" params="['componentItem.id':componentItemInstance?.id]" action="create">Add MaintenanceAction</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:componentItemInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:componentItemInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="subAssembly">Sub Assembly:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:componentItemInstance,field:'subAssembly','errors')}">
                                    <g:select optionKey="id" from="${SubAssembly.list()}" name="subAssembly.id" value="${componentItemInstance?.subAssembly?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
