

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit TaskRecurringSchedule</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">TaskRecurringSchedule List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New TaskRecurringSchedule</g:link></span>
        </div>
        <div class="body">
            <h1>Edit TaskRecurringSchedule</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskRecurringScheduleInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskRecurringScheduleInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${taskRecurringScheduleInstance?.id}" />
                <input type="hidden" name="version" value="${taskRecurringScheduleInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recurEvery">Recur Every:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'recurEvery','errors')}">
                                    <input type="text" id="recurEvery" name="recurEvery" value="${fieldValue(bean:taskRecurringScheduleInstance,field:'recurEvery')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskDuration">Task Duration:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'taskDuration','errors')}">
                                    <input type="text" id="taskDuration" name="taskDuration" value="${fieldValue(bean:taskRecurringScheduleInstance,field:'taskDuration')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="generateAhead">Generate Ahead:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'generateAhead','errors')}">
                                    <input type="text" id="generateAhead" name="generateAhead" value="${fieldValue(bean:taskRecurringScheduleInstance,field:'generateAhead')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="lastGeneratedDate">Last Generated Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'lastGeneratedDate','errors')}">
                                    <g:datePicker name="lastGeneratedDate" value="${taskRecurringScheduleInstance?.lastGeneratedDate}" noSelection="['':'']"></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="lastGeneratedSubTask">Last Generated Sub Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'lastGeneratedSubTask','errors')}">
                                    <g:select optionKey="id" from="${Task.list()}" name="lastGeneratedSubTask.id" value="${taskRecurringScheduleInstance?.lastGeneratedSubTask?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="generateAheadPeriod">Generate Ahead Period:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'generateAheadPeriod','errors')}">
                                    <g:select optionKey="id" from="${Period.list()}" name="generateAheadPeriod.id" value="${taskRecurringScheduleInstance?.generateAheadPeriod?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isEnabled">Is Enabled:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'isEnabled','errors')}">
                                    <g:checkBox name="isEnabled" value="${taskRecurringScheduleInstance?.isEnabled}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="nextGenerationDate">Next Generation Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'nextGenerationDate','errors')}">
                                    <g:datePicker name="nextGenerationDate" value="${taskRecurringScheduleInstance?.nextGenerationDate}" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="nextTargetCompletionDate">Next Target Completion Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'nextTargetCompletionDate','errors')}">
                                    <g:datePicker name="nextTargetCompletionDate" value="${taskRecurringScheduleInstance?.nextTargetCompletionDate}" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="nextTargetStartDate">Next Target Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'nextTargetStartDate','errors')}">
                                    <g:datePicker name="nextTargetStartDate" value="${taskRecurringScheduleInstance?.nextTargetStartDate}" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recurPeriod">Recur Period:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'recurPeriod','errors')}">
                                    <g:select optionKey="id" from="${Period.list()}" name="recurPeriod.id" value="${taskRecurringScheduleInstance?.recurPeriod?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="startDate">Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'startDate','errors')}">
                                    <g:datePicker name="startDate" value="${taskRecurringScheduleInstance?.startDate}" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'task','errors')}">
                                    <g:select optionKey="id" from="${Task.list()}" name="task.id" value="${taskRecurringScheduleInstance?.task?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskDurationPeriod">Task Duration Period:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskRecurringScheduleInstance,field:'taskDurationPeriod','errors')}">
                                    <g:select optionKey="id" from="${Period.list()}" name="taskDurationPeriod.id" value="${taskRecurringScheduleInstance?.taskDurationPeriod?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
