import org.codehaus.groovy.grails.plugins.springsecurity.Secured
import org.codehaus.groovy.grails.commons.ConfigurationHolder

class TaskDetailedController extends BaseController {

    def authenticateService
    def dateUtilService
    def taskService
    def taskSearchService
    def filterService
    def exportService

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def index = { redirect(action:search,params:params) }

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100 )
        [ taskInstanceList: Task.list( params ), taskInstanceTotal: Task.count() ]
    }

    def search = {
//         println params
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100 )

        // Quick Search:
        if(!params.filter)
        {
            def taskInstanceList = []
            def personInstance = Person.get(authenticateService.userDomain().id)

            if(params.quickSearch == "searchMyTodays") {
                taskInstanceList = taskSearchService.getMyTodays(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Today's tasks for ${personInstance.firstName} ${personInstance.lastName}." }
                else { params.message = "No tasks found for today." }
            }
            else if(params.quickSearch == "searchInTheLastWeek") {
                taskInstanceList = taskSearchService.getInTheLastWeek(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Tasks with Target Start Date in the last week." }
                else { params.message = "No tasks found for today." }
            }
            else if(params.quickSearch == "searchMyInTheLastWeek") {
                taskInstanceList = taskSearchService.getMyInTheLastWeek(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Tasks with Target Start Date in the last week for ${personInstance.firstName} ${personInstance.lastName}." }
                else { params.message = "No tasks found for today." }
            }
            else {
                //Default:
                taskInstanceList = taskSearchService.getTodays(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Today's tasks." }
                else { params.message = "No tasks found for today." }
                params.quickSearch = "searchTodays"
            }
            return[taskInstanceList: taskInstanceList, taskInstanceTotal: taskInstanceList.totalCount, filterParams: params]
        }
        // filterPane:
        return[ taskInstanceList: filterService.filter( params, Task ),
            taskInstanceTotal: filterService.count( params, Task ),
            filterParams: com.zeddware.grails.plugins.filterpane.FilterUtils.extractFilterParams(params),
            params:params ]
    }

    def searchCalendar = {
//         println params
        params.max = 30

        // Quick Search:
        if(!params.filter)
        {
            def taskInstanceList = []
            def personInstance = Person.get(authenticateService.userDomain().id)

            if(params.quickSearch == "searchMyTodays") {
                taskInstanceList = taskSearchService.getMyTodays(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Today's tasks for ${personInstance.firstName} ${personInstance.lastName}." }
                else { params.message = "No tasks found for today." }
                if(taskInstanceList.totalCount > params.max) { params.message = "Too many results, only the first ${params.max} shown" }
            }
            else if(params.quickSearch == "searchInTheLastWeek") {
                taskInstanceList = taskSearchService.getInTheLastWeek(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Tasks with Target Start Date in the last week." }
                else { params.message = "No tasks found for today." }
                if(taskInstanceList.totalCount > params.max) { params.message = "Too many results, only the first ${params.max} shown" }
            }
            else if(params.quickSearch == "searchMyInTheLastWeek") {
                taskInstanceList = taskSearchService.getMyInTheLastWeek(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Tasks with Target Start Date in the last week for ${personInstance.firstName} ${personInstance.lastName}." }
                else { params.message = "No tasks found for today." }
                if(taskInstanceList.totalCount > params.max) { params.message = "Too many results, only the first ${params.max} shown" }
            }
            else {
                //Default:
                taskInstanceList = taskSearchService.getTodays(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Today's tasks." }
                else { params.message = "No tasks found for today." }
                if(taskInstanceList.totalCount > params.max) { params.message = "Too many results, only the first ${params.max} shown" }
                params.quickSearch = "searchTodays"
            }
            return[taskInstanceList: taskInstanceList, taskInstanceTotal: taskInstanceList.totalCount, filterParams: params]
        }
        // filterPane:
        def taskInstanceTotal = filterService.count( params, Task )
        if(taskInstanceTotal > params.max) { params.message = "Too many results, only the first ${params.max} shown" }
        return[ taskInstanceList: filterService.filter( params, Task ),
            taskInstanceTotal: taskInstanceTotal,
            filterParams: com.zeddware.grails.plugins.filterpane.FilterUtils.extractFilterParams(params),
            params:params ]
    }

    def budget = {
//         println params
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100 )

        // Quick Search:
        if(!params.filter)
        {
            def taskInstanceList = []
            def personInstance = Person.get(authenticateService.userDomain().id)

            if(params.quickSearch == "budgetUnplanned") {
                taskInstanceList = taskSearchService.getBudgetUnplanned(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Budget unplanned tasks in the last week." }
                else { params.message = "No tasks found." }
            }
            //else if(params.quickSearch == "budgetPlanned") {
            else {
                //Default:
                taskInstanceList = taskSearchService.getBudgetPlanned(params)
                if(taskInstanceList.totalCount > 0) { params.message = "Budget planned Tasks in the last week." }
                else { params.message = "No tasks found.." }
            }
            // export plugin:
            if(params?.format && params.format != "html") {
                response.contentType = ConfigurationHolder.config.grails.mime.types[params.format]
                response.setHeader("Content-disposition", "attachment; filename=tasks.${params.extension}")
                List fields = ["id", "targetStartDate", "description", "leadPerson", "taskStatus", "taskType"]
                Map labels = ["id": "ID", "targetStartDate": "Target Start Date", "description": "Description",
                                        "leadPerson": "Lead Person", "taskStatus": "Task Status", "taskType": "Task Type"]
                Map formatters = [:]
                String title = "${params.quickSearch} tasks in the last week."
                Map parameters = [title: title]

                exportService.export(params.format, response.outputStream, taskInstanceList, fields, labels, formatters, parameters) 
            }
            return[taskInstanceList: taskInstanceList, taskInstanceTotal: taskInstanceList.totalCount, filterParams: params]
        }
        // filterPane:
        return[ taskInstanceList: filterService.filter( params, Task ),
            taskInstanceTotal: filterService.count( params, Task ),
            filterParams: com.zeddware.grails.plugins.filterpane.FilterUtils.extractFilterParams(params),
            params:params ]
    }

    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
        { params.action='show' }

        def taskInstance = Task.get( params.id )

        if(!taskInstance) {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:search)
        }
        else {
            params.max = 10
            params.order = "desc"
            params.sort = "id"

            def entryWorkDoneList = Entry.withCriteria {
                                                                def entryType = EntryType.findByName("WorkDone")
                                                                eq("entryType", entryType)
                                                                eq("task", taskInstance)
                                                        }

            def entryFaultList = Entry.withCriteria {
                                                                def entryType = EntryType.findByName("Fault")
                                                                eq("entryType", entryType)
                                                                eq("task", taskInstance)
                                                        }

            def subTaskInstanceList = Task.findAllByParentTask(taskInstance, params)
            def subTaskInstanceTotal = Task.countByParentTask(taskInstance)
            def showTaskTab = new String("true")

            def inventoryMovementList = InventoryMovement.findAllByTask(taskInstance, [max:100, sort:"id", order:"desc", offset:0])

            def taskModificationList = TaskModification.findAllByTask(taskInstance, [max:100, sort:"id", order:"asc", offset:0])

            def taskProcedureInstance = TaskProcedure.get(taskInstance.taskProcedure?.id)
            def taskProcedureExits = new Boolean("true")
            if(!taskProcedureInstance) {
                taskProcedureExits = false
            }

            params.order = "asc"
            params.sort = "procedureStepNumber"
            def maintenanceActionList = MaintenanceAction.findAllByTaskProcedure(taskProcedureInstance, params)

            def taskRecurringScheduleInstance = TaskRecurringSchedule.get(taskInstance.taskRecurringSchedule?.id)
            def taskRecurringScheduleExits= new Boolean("true")
            if(!taskRecurringScheduleInstance) {
                taskRecurringScheduleExits = false
            }

            return [ taskInstance: taskInstance,
                            entryWorkDoneList: entryWorkDoneList,
                            entryFaultList: entryFaultList,
                            taskProcedureInstance: taskProcedureInstance,
                            taskProcedureExits: taskProcedureExits,
                            showTaskTab: showTaskTab,
                            subTaskInstanceList: subTaskInstanceList,
                            subTaskInstanceTotal: subTaskInstanceTotal,
                            subTaskInstanceMax: params.max,
                            maintenanceActionList: maintenanceActionList,
                            taskRecurringScheduleInstance: taskRecurringScheduleInstance,
                            taskRecurringScheduleExits: taskRecurringScheduleExits,
                            inventoryMovementList: inventoryMovementList,
                            taskModificationList: taskModificationList]
        }
    }

    def delete = {
        def taskInstance = Task.get( params.id )
        if(taskInstance) {
            try {
                taskInstance.isActive = false
                flash.message = "Task ${params.id} has been set to inactive."
                redirect(action:search)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Task ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:search)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
        { params.action='edit' }

        def taskInstance = Task.get( params.id )

        if(!taskInstance) {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:search)
        }
        else {
            def criteria = taskInstance.createCriteria()
            def possibleParentList = criteria {
                and {
                    notEqual('id', taskInstance.id)
                    taskInstance.subTasks.each() { notEqual('id', it.id) }
                    }
            }
            return [ taskInstance : taskInstance, possibleParentList: possibleParentList ]
        }
    }

    def update = {

        if(!Task.exists(params.id)) {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:'search')
        }

        def result = taskService.update(params)

        if(!result.error) {
                flash.message = "Task ${params.id} updated"
                redirect(action:show,id:result.taskInstance.id)
        }
        else {
            if(result.taskInstance) {
                render(view:'edit',model:[taskInstance:result.taskInstance])
            }
            else {
                flash.message = "Task could not be updated."
                redirect(action:'search')
            }
        }

    }

//     def update = {
//         def taskInstance = Task.get( params.id )
//         if(taskInstance) {
//             if(params.version) {
//                 def version = params.version.toLong()
//                 if(taskInstance.version > version) {
// 
//                     taskInstance.errors.rejectValue("version", "task.optimistic.locking.failure", "Another user has updated this Task while you were editing.")
//                     render(view:'edit',model:[taskInstance:taskInstance])
//                     return
//                 }
//             }
//             taskInstance.properties = params
//             if(!taskInstance.hasErrors() && taskInstance.save(flush: true)) {
//                 flash.message = "Task ${params.id} updated"
//                 redirect(action:show,id:taskInstance.id)
//             }
//             else {
//                 render(view:'edit',model:[taskInstance:taskInstance])
//             }
//         }
//         else {
//             flash.message = "Task not found with id ${params.id}"
//             redirect(action:edit,id:params.id)
//         }
//     }

    def create = {
        def taskInstance = new Task()
        taskInstance.properties = params
        return ['taskInstance':taskInstance]
    }

    def save = {
        def result = taskService.create(params)

        if(!result.error) {
            flash.message = "Task ${result.taskInstance.id} created."
            redirect(action: show,id: result.taskInstance.id)
        }
        else {
            if(result.taskInstance) {
                render(view:'create',model:[taskInstance:result.taskInstance])
            }
            else {
                flash.message = "Could not create task."
                redirect(action:"search")
            }

        }
    }

    def listSubTasks = {
        def parentTaskInstance = Task.get(params.id)

        if(!parentTaskInstance) {
            flash.message = "Task not found with id ${params.id}"
            redirect(action:search)
        }
        else {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        def subTaskInstanceList = Task.findAllByParentTask(parentTaskInstance, params)
        def subTaskInstanceTotal = Task.countByParentTask(parentTaskInstance)

        [ taskInstanceList: subTaskInstanceList,
            taskInstanceTotal:  subTaskInstanceTotal,
            parentTaskInstance: parentTaskInstance]
        }
    }

}
