class TaskService {

    boolean transactional = false

    def dateUtilService
    def authenticateService

    def create(params) {
        Task.withTransaction { status ->
            def result = [:]
            def taskInstance = new Task(params)
            result.taskInstance = taskInstance

            // Get person in a safe way to avoid a null userDomain during bootstrap.
            def userDomain = authenticateService.userDomain()
            def person = userDomain ? Person.get(userDomain.id) : Person.get(1)

            if(taskInstance.save()) {
                def taskModification = new TaskModification(person:person,
                                                        taskModificationType: TaskModificationType.get(1),
                                                        task: taskInstance)

                if(!taskModification.save()) {
                    status.setRollbackOnly()
                    taskInstance.errors.rejectValue("taskModifications", "task.modifications.failedToSave")
                    result.error = true
                    return result
                }

                return result
            }
            else {
                result.error = true
                return result
            }

        } //end withTransaction
    } // end create()

    def start() {
        //TaskModificationType.get(2)
    }  // end start()

    def update(params) {
        Task.withTransaction { status ->
            def result = [:]
            result.taskInstance = Task.get(params.id)
            if(result.taskInstance) {

                // Optimistic locking check.
                if(params.version) {
                    def version = params.version.toLong()
                    if(result.taskInstance.version > version) {
                        status.setRollbackOnly()
                        result.taskInstance.errors.rejectValue("version", "task.optimistic.locking.failure", "Another user has updated this Task while you were editing.")
                        result.error = true
                        return result
                    }
                }


                result.taskInstance.properties = params

                if(result.taskInstance.save()) {
                    def taskModification = new TaskModification(person:Person.get(authenticateService.userDomain().id),
                                                            taskModificationType: TaskModificationType.get(3),
                                                            task: result.taskInstance)
                    if(taskModification.save()) {
                        // All went well.
                        return result
                    }
                    else {
                        status.setRollbackOnly()
                        result.taskInstance.errors.rejectValue("taskModifications", "task.modifications.failedToSave")
                        result.error = true
                        return result
                    }
                }
            }
            // Something failed.
            status.setRollbackOnly()
            result.error = true
            return result

        } //end withTransaction
    }  // end update()

    def complete() {
        //TaskModificationType.get(4)
    }  // end complete()

    def reopen() {
        //TaskModificationType.get(5)
    }  // end reopen()

    def trash() {
        //TaskModificationType.get(6)
    }  // end trash()

    def restore() {
        //TaskModificationType.get(7)
    }  // end restore()

    def approve() {
        //TaskModificationType.get(8)
    }  // end approve()

    def renegeApproval() {
        //TaskModificationType.get(9)
    }  // end renegeApproval()

} // end TaskService
