class TypeOfPersonGroupController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ typeOfPersonGroupInstanceList: TypeOfPersonGroup.list( params ) ]
    }

    def show = {
        def typeOfPersonGroupInstance = TypeOfPersonGroup.get( params.id )

        if(!typeOfPersonGroupInstance) {
            flash.message = "TypeOfPersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ typeOfPersonGroupInstance : typeOfPersonGroupInstance ] }
    }

    def delete = {
        def typeOfPersonGroupInstance = TypeOfPersonGroup.get( params.id )
        if(typeOfPersonGroupInstance) {
            typeOfPersonGroupInstance.delete()
            flash.message = "TypeOfPersonGroup ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "TypeOfPersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def typeOfPersonGroupInstance = TypeOfPersonGroup.get( params.id )

        if(!typeOfPersonGroupInstance) {
            flash.message = "TypeOfPersonGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ typeOfPersonGroupInstance : typeOfPersonGroupInstance ]
        }
    }

    def update = {
        def typeOfPersonGroupInstance = TypeOfPersonGroup.get( params.id )
        if(typeOfPersonGroupInstance) {
            typeOfPersonGroupInstance.properties = params
            if(!typeOfPersonGroupInstance.hasErrors() && typeOfPersonGroupInstance.save()) {
                flash.message = "TypeOfPersonGroup ${params.id} updated"
                redirect(action:show,id:typeOfPersonGroupInstance.id)
            }
            else {
                render(view:'edit',model:[typeOfPersonGroupInstance:typeOfPersonGroupInstance])
            }
        }
        else {
            flash.message = "TypeOfPersonGroup not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def typeOfPersonGroupInstance = new TypeOfPersonGroup()
        typeOfPersonGroupInstance.properties = params
        return ['typeOfPersonGroupInstance':typeOfPersonGroupInstance]
    }

    def save = {
        def typeOfPersonGroupInstance = new TypeOfPersonGroup(params)
        if(!typeOfPersonGroupInstance.hasErrors() && typeOfPersonGroupInstance.save()) {
            flash.message = "TypeOfPersonGroup ${typeOfPersonGroupInstance.id} created"
            redirect(action:show,id:typeOfPersonGroupInstance.id)
        }
        else {
            render(view:'create',model:[typeOfPersonGroupInstance:typeOfPersonGroupInstance])
        }
    }
}
