

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Task #${taskInstance?.id}</title>
        <nav:resources override="true"/>
        <resource:dateChooser />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${taskInstance?.id}" />
                <input type="hidden" name="version" value="${taskInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="id">Id:</label>
                                </td>
                                <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'id')}</td>
                            </tr>

                            <g:if test="${taskInstance?.parentTask}">
                                <tr class="prop">
                                    <td valign="top" class="name">Parent Task:</td>

                                    <td valign="top" class="value"><g:link controller="taskDetailed" action="show" id="${taskInstance.parentTask.id}">${taskInstance.parentTask.encodeAsHTML()}</g:link></td>

                                </tr>
                            </g:if>

<!--                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="parentTask">Parent Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'parentTask','errors')}">
                                    <g:select optionKey="id" from="${possibleParentList}" name="parentTask.id" value="${taskInstance?.parentTask?.id}" noSelection="['null':'--None--']"></g:select>
                                </td>
                            </tr>-->

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'description','errors')}">
                                    <input type="text" style="width:450px" maxlength="75" id="description" name="description" value="${fieldValue(bean:taskInstance,field:'description')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'comment','errors')}">
                                    <textarea style="width:450px" rows="5" cols="40" name="comment">${fieldValue(bean:taskInstance, field:'comment')}</textarea>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetStartDate">Target Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetStartDate','errors')}">
                                    <richui:dateChooser name="targetStartDate" format="dd-MM-yyyy" value="${taskInstance?.targetStartDate}" />
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetCompletionDate">Target Completion Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetCompletionDate','errors')}">
                                    <richui:dateChooser name="targetCompletionDate" format="dd-MM-yyyy" value="${taskInstance?.targetCompletionDate}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="leadPerson">Lead Person:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'leadPerson','errors')}">
                                    <g:select optionKey="id" from="${Person.list()}" name="leadPerson.id" value="${taskInstance?.leadPerson?.id}" ></g:select>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="primaryAsset">Primary Asset:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'primaryAsset','errors')}">
                                    <g:select optionKey="id" from="${Asset.list()}" name="primaryAsset.id" value="${taskInstance?.primaryAsset?.id}"  noSelection="['null':'--None--']"></g:select>
                                    <g:helpBalloon code="task.primaryAsset" />
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="associatedAssets">Associated Assets:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'associatedAssets','errors')}">
                                    <g:select id="associatedAssets" name="associatedAssets"
                                                    from="${Asset.list()}"
                                                    optionKey="id" size="5" multiple="yes" 
                                                    value="${taskInstance?.associatedAssets.id}"  noSelection="['':'--None--']"/>
                                    <g:helpBalloon  class="helpballoon" code="task.associatedAssets" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskPriority">Task Priority:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskPriority','errors')}">
                                    <g:select optionKey="id" from="${TaskPriority.list()}" name="taskPriority.id" value="${taskInstance?.taskPriority?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="scheduled">Scheduled:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'scheduled','errors')}">
                                    <g:checkBox name="scheduled" value="${taskInstance?.scheduled}" ></g:checkBox>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskGroup">Task Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskGroup','errors')}">
                                    <g:select optionKey="id" from="${TaskGroup.list()}" name="taskGroup.id" value="${taskInstance?.taskGroup?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskType">Task Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskType','errors')}">
                                    <g:select optionKey="id" from="${TaskType.list()}" name="taskType.id" value="${taskInstance?.taskType?.id}" ></g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assignedPersons">Assigned Groups:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'assignedGroups','errors')}">
                                    
                                <ul>
                                <g:each var="a" in="${taskInstance?.assignedGroups?}">
                                    <li><g:link controller="assignedGroupDetailed" action="edit" id="${a.id}" params="['task.id':taskInstance?.id]">${a?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>

                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assignedPersons">Assigned Persons:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'assignedPersons','errors')}">
                                    
                                <ul>
                                <g:each var="a" in="${taskInstance?.assignedPersons?}">
                                    <li><g:link controller="assignedPersonDetailed" action="edit" id="${a.id}" params="['task.id':taskInstance?.id]">${a?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>

                                </td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="trash" onclick="return confirm('Are you sure?');" value="Trash" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
