import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssignedGroupDetailedController extends BaseController {

    def assignedGroupService

    def index = {
        flash.message = g.message(code: "assignedGroup.task.not.found")
        redirect(controller:"taskDetailed", action:"search")
    }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
            def result = assignedGroupService.list(params)
            if(!result.error) {
                return [ assignedGroupInstanceList: result.assignedGroupInstanceList,
                                assignedGroupInstanceTotal: result.assignedGroupInstanceTotal ]
            }

            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect( url: resource(dir:'') )
    }

    def show = {
        def result = assignedGroupService.show(params)

        if(!result.error)
            return [ assignedGroupInstance: result.assignedGroupInstance ]

        flash.message = g.message(code: result.error.code, args: result.error.args)

        if(params.task?.id)
            redirect(controller:"taskDetailed", action:"show", id: params.task.id)

        redirect(controller:"taskDetailed", action:"search")
    }

    def delete = {
        def result = assignedGroupService.delete(params)

        if(!result.error) {
            flash.message = g.message(code: "default.delete.success", args: ["AssignedGroup", params.id])
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        redirect(action:show, id: params.id)
    }

    def edit = {
        def result = assignedGroupService.edit(params)

        if(!result.error)
            return [ assignedGroupInstance : result.assignedGroupInstance ]

        flash.message = g.message(code: result.error.code, args: result.error.args)

        redirect(controller:"taskDetailed", action:"show", id: params.task?.id)

    }

    def update = {
        def result = assignedGroupService.update(params)

        if(!result.error) {
            flash.message = g.message(code: "default.update.success", args: ["AssignedGroup", params.id])
            redirect(action:show, id: params.id)
            return
        }

        if(result.error.code == "default.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        render(view:'edit', model:[assignedGroupInstance: result.assignedGroupInstance.attach()])
    }

    def create = {
        def result = assignedGroupService.create(params)

        if(!result.error)
            return [assignedGroupInstance: result.assignedGroupInstance]

        if(result.error.code == "assignedGroup.task.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller: "taskDetailed", action: "search")
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)
        redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
    }

    def save = {
        def result = assignedGroupService.save(params)

        if(!result.error) {
            flash.message = g.message(code: "default.create.success", args: ["AssignedGroup", result.assignedGroupInstance.id])
            redirect(controller:"taskDetailed", action:"show", id: result.assignedGroupInstance.task.id)
            return
        }

        render(view:'edit', model:[assignedGroupInstance: result.assignedGroupInstance])
    }

}
