import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class SectionExtendedAttributeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ sectionExtendedAttributeInstanceList: SectionExtendedAttribute.list( params ), sectionExtendedAttributeInstanceTotal: SectionExtendedAttribute.count() ]
    }

    def show = {
        def sectionExtendedAttributeInstance = SectionExtendedAttribute.get( params.id )

        if(!sectionExtendedAttributeInstance) {
            flash.message = "SectionExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ sectionExtendedAttributeInstance : sectionExtendedAttributeInstance ] }
    }

    def delete = {
        def sectionExtendedAttributeInstance = SectionExtendedAttribute.get( params.id )
        if(sectionExtendedAttributeInstance) {
            try {
                sectionExtendedAttributeInstance.delete(flush:true)
                flash.message = "SectionExtendedAttribute ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "SectionExtendedAttribute ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "SectionExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def sectionExtendedAttributeInstance = SectionExtendedAttribute.get( params.id )

        if(!sectionExtendedAttributeInstance) {
            flash.message = "SectionExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ sectionExtendedAttributeInstance : sectionExtendedAttributeInstance ]
        }
    }

    def update = {
        def sectionExtendedAttributeInstance = SectionExtendedAttribute.get( params.id )
        if(sectionExtendedAttributeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(sectionExtendedAttributeInstance.version > version) {
                    
                    sectionExtendedAttributeInstance.errors.rejectValue("version", "sectionExtendedAttribute.optimistic.locking.failure", "Another user has updated this SectionExtendedAttribute while you were editing.")
                    render(view:'edit',model:[sectionExtendedAttributeInstance:sectionExtendedAttributeInstance])
                    return
                }
            }
            sectionExtendedAttributeInstance.properties = params
            if(!sectionExtendedAttributeInstance.hasErrors() && sectionExtendedAttributeInstance.save(flush: true)) {
                flash.message = "SectionExtendedAttribute ${params.id} updated"
                redirect(action:show,id:sectionExtendedAttributeInstance.id)
            }
            else {
                render(view:'edit',model:[sectionExtendedAttributeInstance:sectionExtendedAttributeInstance])
            }
        }
        else {
            flash.message = "SectionExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def sectionExtendedAttributeInstance = new SectionExtendedAttribute()
        sectionExtendedAttributeInstance.properties = params
        return ['sectionExtendedAttributeInstance':sectionExtendedAttributeInstance]
    }

    def save = {
        def sectionExtendedAttributeInstance = new SectionExtendedAttribute(params)
        if(!sectionExtendedAttributeInstance.hasErrors() && sectionExtendedAttributeInstance.save(flush: true)) {
            flash.message = "SectionExtendedAttribute ${sectionExtendedAttributeInstance.id} created"
            redirect(action:show,id:sectionExtendedAttributeInstance.id)
        }
        else {
            render(view:'create',model:[sectionExtendedAttributeInstance:sectionExtendedAttributeInstance])
        }
    }
}
