import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssetSubItemExtendedAttributeDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ assetSubItemExtendedAttributeInstanceList: AssetSubItemExtendedAttribute.list( params ), assetSubItemExtendedAttributeInstanceTotal: AssetSubItemExtendedAttribute.count() ]
    }

    def show = {
        def assetSubItemExtendedAttributeInstance = AssetSubItemExtendedAttribute.get( params.id )

        if(!assetSubItemExtendedAttributeInstance) {
            flash.message = "AssetSubItemExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ assetSubItemExtendedAttributeInstance : assetSubItemExtendedAttributeInstance ] }
    }

    def delete = {
        def assetSubItemExtendedAttributeInstance = AssetSubItemExtendedAttribute.get( params.id )
        if(assetSubItemExtendedAttributeInstance) {
            try {
                assetSubItemExtendedAttributeInstance.delete(flush:true)
                flash.message = "AssetSubItemExtendedAttribute ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AssetSubItemExtendedAttribute ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AssetSubItemExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def assetSubItemExtendedAttributeInstance = AssetSubItemExtendedAttribute.get( params.id )

        if(!assetSubItemExtendedAttributeInstance) {
            flash.message = "AssetSubItemExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ assetSubItemExtendedAttributeInstance : assetSubItemExtendedAttributeInstance ]
        }
    }

    def update = {
        def assetSubItemExtendedAttributeInstance = AssetSubItemExtendedAttribute.get( params.id )
        if(assetSubItemExtendedAttributeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assetSubItemExtendedAttributeInstance.version > version) {
                    
                    assetSubItemExtendedAttributeInstance.errors.rejectValue("version", "assetSubItemExtendedAttribute.optimistic.locking.failure", "Another user has updated this AssetSubItemExtendedAttribute while you were editing.")
                    render(view:'edit',model:[assetSubItemExtendedAttributeInstance:assetSubItemExtendedAttributeInstance])
                    return
                }
            }
            assetSubItemExtendedAttributeInstance.properties = params
            if(!assetSubItemExtendedAttributeInstance.hasErrors() && assetSubItemExtendedAttributeInstance.save(flush: true)) {
                flash.message = "AssetSubItemExtendedAttribute ${params.id} updated"
                redirect(action:show,id:assetSubItemExtendedAttributeInstance.id)
            }
            else {
                render(view:'edit',model:[assetSubItemExtendedAttributeInstance:assetSubItemExtendedAttributeInstance])
            }
        }
        else {
            flash.message = "AssetSubItemExtendedAttribute not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def assetSubItemExtendedAttributeInstance = new AssetSubItemExtendedAttribute()
        assetSubItemExtendedAttributeInstance.properties = params
        return ['assetSubItemExtendedAttributeInstance':assetSubItemExtendedAttributeInstance]
    }

    def save = {
        def assetSubItemExtendedAttributeInstance = new AssetSubItemExtendedAttribute(params)
        if(!assetSubItemExtendedAttributeInstance.hasErrors() && assetSubItemExtendedAttributeInstance.save(flush: true)) {
            flash.message = "AssetSubItemExtendedAttribute ${assetSubItemExtendedAttributeInstance.id} created"
            redirect(action:show,id:assetSubItemExtendedAttributeInstance.id)
        }
        else {
            render(view:'create',model:[assetSubItemExtendedAttributeInstance:assetSubItemExtendedAttributeInstance])
        }
    }
}
