
class AssetTreeTagLib {
    static namespace = 'gnumims'

    def resources = { attrs ->
        ///@todo: should include our javascript and do setup here.
    }

    def assetTree = { attrs ->

        def sites = Site.list()

        def assetInstance = Asset.get(1) /// @todo: remove this.

        def divIdCount = 0
        def divId = ''
        def nextDivId = {
            divIdCount++
            divId = 'assetTreeBranch'+divIdCount
        }

        def mkp = new groovy.xml.MarkupBuilder(out) //this line will be unnecessary in versions of Grails after version 1.2


        /// @todo: use a loop for the subItem levels.
        mkp.div(class: 'tree') {
            ul() {
                img(src: treeRootImg(), alt: 'TreeRoot')
                for(site in sites.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                    li() {
                        if(site.sections) {
                            a(href: toggleBranch(nextDivId()) ) {
                                img( src: bulletTreePlusImg(), id: divId+'img' )
                            }
                        }
                        else
                            img(src: dashImg())
                        a( href: siteShowLink(site.id) ) {
                            yieldUnescaped( site.encodeAsHTML() )
                        }
                        a(href: sectionCreateLink(site.id)) {
                            img(src: addImg(), alt: 'Add', title: 'Add Section')
                        }
                    }
                    if(site.sections) {
                        div(id: divId,  style: 'display:none;') {
                            ul() {
                                for(section in site.sections.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                    li() {
                                        if(section.assets) {
                                            a(href: toggleBranch(nextDivId()) ) {
                                                img(src: bulletTreePlusImg(), id: divId+'img' )
                                            }
                                        }
                                        else
                                            img(src: dashImg())
                                        a( href: sectionShowLink(section.id) ) {
                                            yieldUnescaped( section.encodeAsHTML() )
                                        }
                                        a(href: assetCreateLink(section.id)) {
                                            img(src: addImg(), alt: 'Add', title: 'Add Asset')
                                        }
                                    }

                                    if(section.assets) {
                                        div(id: divId,  style: 'display:none;') {
                                            ul() {
                                                for(asset in section.assets.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                    li() {
                                                        if(asset.assetSubItems) {
                                                            a(href: toggleBranch(nextDivId()) ) {
                                                                img(src: bulletTreePlusImg(), id: divId+'img' )
                                                            }
                                                        }
                                                        else
                                                            img(src: dashImg())
                                                        a( href: assetShowLink(asset.id) ) {
                                                            yieldUnescaped( asset.encodeAsHTML() )
                                                        }
                                                        a(href: assetSubItemCreateLink(asset.id)) {
                                                            img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                                                        }
                                                    } // li

                                                    if(asset.assetSubItems) {
                                                        div(id: divId,  style: 'display:none;') {
                                                            ul() {
                                                                for(assetSubItemL1 in asset.assetSubItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                    li() {
                                                                        if(assetSubItemL1.subItems) {
                                                                            a(href: toggleBranch(nextDivId()) ) {
                                                                                img(src: bulletTreePlusImg(), id: divId+'img' )
                                                                            }
                                                                        }
                                                                        else
                                                                            img(src: dashImg())
                                                                        a( href: assetSubItemShowLink(assetSubItemL1.id) ) {
                                                                            yieldUnescaped( assetSubItemL1.encodeAsHTML() )
                                                                        }
                                                                        a(href: assetSubItemCreateWithParentLink(assetSubItemL1.id)) {
                                                                            img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                                                                        }
                                                                    } // li

                                                                    if(assetSubItemL1.subItems) {
                                                                        div(id: divId,  style: 'display:none;') {
                                                                            ul() {
                                                                                for(assetSubItemL2 in assetSubItemL1.subItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                                    li() {
                                                                                        if(assetSubItemL2.subItems) {
                                                                                            a(href: toggleBranch(nextDivId()) ) {
                                                                                                img( src: bulletTreePlusImg(), id: divId+'img' )
                                                                                            }
                                                                                        }
                                                                                        else
                                                                                            img(src: dashImg())
                                                                                        a( href: assetSubItemShowLink(assetSubItemL2.id) ) {
                                                                                            yieldUnescaped( assetSubItemL2.encodeAsHTML() )
                                                                                        }
                                                                                        a(href: assetSubItemCreateWithParentLink(assetSubItemL2.id)) {
                                                                                            img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                                                                                        }
                                                                                    } // li

                                                                                    if(assetSubItemL2.subItems) {
                                                                                        div(id: divId,  style: 'display:none;') {
                                                                                            ul() {
                                                                                                for(assetSubItemL3 in assetSubItemL2.subItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                                                    li() {
                                                                                                        if(assetSubItemL3.subItems) {
                                                                                                            a(href: toggleBranch(nextDivId()) ) {
                                                                                                                img( src: bulletTreePlusImg(), id: divId+'img' )
                                                                                                            }
                                                                                                        }
                                                                                                        else
                                                                                                            img(src: dashImg())
                                                                                                        a( href: assetSubItemShowLink(assetSubItemL3.id) ) {
                                                                                                            yieldUnescaped( assetSubItemL3.encodeAsHTML() )
                                                                                                        }
                                                                                                        a(href: assetSubItemCreateWithParentLink(assetSubItemL3.id)) {
                                                                                                            img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
                                                                                                        }
                                                                                                    } // li

                                                                                                    if(assetSubItemL3.subItems) {
                                                                                                        div(id: divId,  style: 'display:none;') {
                                                                                                            ul() {
                                                                                                                for(assetSubItemL4 in assetSubItemL3.subItems.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }) {
                                                                                                                    li() {
//                                                                                                                         if(assetSubItemL4.subItems) {
//                                                                                                                             a(href: toggleBranch(nextDivId()) ) {
//                                                                                                                                 img( src: bulletTreePlusImg(), id: divId+'img' )
//                                                                                                                             }
//                                                                                                                         }
//                                                                                                                         else
                                                                                                                        img(src: dashImg())
                                                                                                                        a( href: assetSubItemShowLink(assetSubItemL4.id) ) {
                                                                                                                            yieldUnescaped( assetSubItemL4.encodeAsHTML() )
                                                                                                                        }
//                                                                                                                         a(href: assetSubItemCreateWithParentLink(assetSubItemL4.id)) {
//                                                                                                                             img(src: addImg(), alt: 'Add', title: 'Add Sub Item')
//                                                                                                                         }
                                                                                                                    } // li

                                                                                                                } // assetSubItemL4
                                                                                                            } // ul
                                                                                                        } // div
                                                                                                    } // if(assetSubItemL3.subItems)


                                                                                                } // assetSubItemL3
                                                                                            } // ul
                                                                                        } // div
                                                                                    } // if(assetSubItemL2.subItems)

                                                                                } // assetSubItemL2
                                                                            } // ul
                                                                        } // div
                                                                    } // if(assetSubItemL1.subItems)

                                                                } // assetSubItemL1
                                                            } // ul
                                                        } // div
                                                    } // if(asset.assetSubItems)

                                                } // assets
                                            } // ul
                                        } // div
                                    } // if(section.assets)

                                } //sections
                            } // ul
                        } // div
                    } // if(site.sections) 
                } // sites
            } // ul
        } // mkp

    } // assetTree



    /** Imgs */

    def treeRootImg() {
        resource(dir:'images/skin',file:'chart_organisation.png').toString()
    }
    def addImg() {
        resource(dir:'images/skin',file:'database_add.png').toString()
    }
    def copyImg() {
        resource(dir:'images/skin',file:'page_copy.png').toString()
    }
    def bulletTreePlusImg() {
        resource(dir:'images/skin',file:'bullet_tree_plus.png').toString()
    }
    // actually set in javascript function.
    def bulletTreeMinusImg() {
        resource(dir:'images/skin',file:'bullet_tree_minus.png').toString()
    }
    def dashImg() {
        resource(dir:'images/skin',file:'hline_short.png').toString()
    }

    /** js calls */

    def toggleBranch(divId) {
        /// @todo: toggleBranch is in overlayPane.js and should be moved to tree.js
       'javascript: toggleBranch(\"' + divId + '\", \"' + divId + 'img' + '\");'
    }

    /** Links */

    def siteShowLink(id) {
        createLink(controller: 'siteDetailed', action: 'show', params: ['id': id] ).toString()
    }

    def siteEditLink(id) {
        createLink(controller: 'siteDetailed', action: 'edit', params: ['id': id] ).toString()
    }

    def sectionCreateLink(id) {
        createLink(controller: 'sectionDetailed', action: 'create', params: ['id': id] ).toString()
    }

    def sectionShowLink(id) {
        createLink(controller: 'sectionDetailed', action: 'show', params: ['id': id] ).toString()
    }

    def sectionEditLink(id) {
        createLink(controller: 'sectionDetailed', action: 'edit', params: ['id': id] ).toString()
    }

    def assetCreateLink(id) {
        createLink(controller: 'assetDetailed', action: 'create', params: ['id': id] ).toString()
    }

    def assetShowLink(id) {
        createLink(controller: 'assetDetailed', action: 'show', id: id ).toString()
    }

    def assetEditLink(id) {
        createLink(controller: 'assetDetailed', action: 'edit', id: id ).toString()
    }

    def assetCopyLink(id) {
        createLink(controller: 'assetDetailed', action: 'copy', params: ['asset.id': id] ).toString()
    }

    def assetSubItemCreateLink(id) {
        createLink(controller: 'assetSubItemDetailed', action: 'create', params: ['id': id] ).toString()
    }

    def assetSubItemCreateWithParentLink(parentItemId) {
        createLink(controller: 'assetSubItemDetailed', action: 'create', params: ['parentItem.id': parentItemId] ).toString()
    }

    def assetSubItemShowLink(id) {
        createLink(controller: 'assetSubItemDetailed', action: 'show', params: ['id': id] ).toString()
    }

    def assetSubItemEditLink(id) {
        createLink(controller: 'assetSubItemDetailed', action: 'edit', params: ['id': id] ).toString()
    }

} // end class