/**
* Provides some javascript utility methods.
* To use include the following in the gsp head:
* <!--
* <g:javascript src="util.js" />
* -->
* @todo: util.js could be placed a taglib resources closure.
*/
class JavascriptService {

    boolean transactional = false

    def g = new org.codehaus.groovy.grails.plugins.web.taglib.ApplicationTagLib()

    /**
    * Toggle the visibility of an html element.
    * @param id The html id of the element.
    * @returns A javascript string that can be assigned to an onclick action.
    */
    def onclickToggle(id) {
        'return toggleUtil(\"' + id + '\");'
    }

    /**
    * Toggle the visibility of an html element.
    * @param id The html id of the element.
    * @returns A javascript string that can be assigned to an anchor href.
    */
    def hrefToggle(id) {
        'javascript: toggleUtil(\"' + id + '\");'
    }

    /**
    * Show an html element by slowly increasing the visibility.
    * @param id The html id of the element.
    * @returns A javascript string that can be assigned to an onclick action.
    */
    def onclickShow(id) {
        'return showUtil(\"' + id + '\");'
    }

    /**
    * Show an html element by slowly increasing the visibility.
    * @param id The html id of the element.
    * @returns A javascript string that can be assigned to an anchor href.
    */
    def hrefShow(id) {
        'javascript: showUtil(\"' + id + '\");'
    }

    /**
    * Hide an html element by slowly decreasing the visibility.
    * @param id The html id of the element.
    * @returns A javascript string that can be assigned to an onclick action.
    */
    def onclickHide(id) {
        'return hideUtil(\"' + id + '\");'
    }

    /**
    * Hide an html element by slowly decreasing the visibility.
    * @param id The html id of the element.
    * @returns A javascript string that can be assigned to an anchor href.
    */
    def hrefHide(id) {
        'javascript: hideUtil(\"' + id + '\");'
    }

} // end class