import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_InventoryManager'])
class ManufacturerDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ manufacturerInstanceList: Manufacturer.list( params ), manufacturerInstanceTotal: Manufacturer.count() ]
    }

    def show = {
        def manufacturerInstance = Manufacturer.get( params.id )

        if(!manufacturerInstance) {
            flash.message = "Manufacturer not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ manufacturerInstance : manufacturerInstance ] }
    }

    def delete = {
        def manufacturerInstance = Manufacturer.get( params.id )
        if(manufacturerInstance) {
            try {
                manufacturerInstance.delete(flush:true)
                flash.message = "Manufacturer ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Manufacturer ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Manufacturer not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def manufacturerInstance = Manufacturer.get( params.id )

        if(!manufacturerInstance) {
            flash.message = "Manufacturer not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ manufacturerInstance : manufacturerInstance ]
        }
    }

    def update = {
        def manufacturerInstance = Manufacturer.get( params.id )
        if(manufacturerInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(manufacturerInstance.version > version) {
                    
                    manufacturerInstance.errors.rejectValue("version", "manufacturer.optimistic.locking.failure", "Another user has updated this Manufacturer while you were editing.")
                    render(view:'edit',model:[manufacturerInstance:manufacturerInstance])
                    return
                }
            }
            manufacturerInstance.properties = params
            if(!manufacturerInstance.hasErrors() && manufacturerInstance.save(flush: true)) {
                flash.message = "Manufacturer ${params.id} updated"
                redirect(action:show,id:manufacturerInstance.id)
            }
            else {
                render(view:'edit',model:[manufacturerInstance:manufacturerInstance])
            }
        }
        else {
            flash.message = "Manufacturer not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def manufacturerInstance = new Manufacturer()
        manufacturerInstance.properties = params
        return ['manufacturerInstance':manufacturerInstance]
    }

    def save = {
        def manufacturerInstance = new Manufacturer(params)
        if(!manufacturerInstance.hasErrors() && manufacturerInstance.save(flush: true)) {
            flash.message = "Manufacturer ${manufacturerInstance.id} created"
            redirect(action:show,id:manufacturerInstance.id)
        }
        else {
            render(view:'create',model:[manufacturerInstance:manufacturerInstance])
        }
    }
}
