

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Supplier</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${supplierInstance}">
            <div class="errors">
                <g:renderErrors bean="${supplierInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${supplierInstance?.id}" />
                <input type="hidden" name="version" value="${supplierInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:supplierInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:supplierInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${supplierInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="supplierType">Supplier Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:supplierInstance,field:'supplierType','errors')}">
                                    <g:select optionKey="id" from="${SupplierType.list()}" name="supplierType.id" value="${supplierInstance?.supplierType?.id}" ></g:select>
                                </td>
                            </tr> 

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="addresses">Addresses:</label>
                                </td>
                                <td valign="top" class="value">
                                    <ul>
                                    <g:each var="i" in="${supplierInstance?.addresses?}">
                                        <li><g:link controller="supplierDetailed" action="show" id="${i.id}">
                                            ${i?.encodeAsHTML()}
                                        </g:link></li>
                                    </g:each>
                                    </ul>
                                    <g:link controller="addressDetailed" params="['supplier.id':supplierInstance?.id]" action="create">Add Address</g:link>
                                </td>
                            </tr>
                            
                            <tr class="prop">
                                <td valign="top" class="name">Inventory Items:</td>
                                
                                <td  valign="top" style="text-align:left;" class="value">
                                    <ul>
                                    <g:each var="i" in="${supplierInstance.inventoryItems}">
                                        <li><g:link controller="inventoryItemDetailed" action="show" id="${i.id}">${i?.encodeAsHTML()}</g:link></li>
                                    </g:each>
                                    </ul>
                                </td>
                                
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
