<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="layout" content="main" />
    <title>Start</title>
    <nav:resources override="true"/>
    <resource:tabView skin="tabviewCustom" />
    <resource:dateChooser />
</head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="true" title="Quick Links" />
                    <richui:tabLabel selected="${0}" title="Reports" />
                    <richui:tabLabel selected="${0}" title="Options" />
                    <richui:tabLabel selected="${0}" title="About" />
                </richui:tabLabels>

                <richui:tabContents>

<!-- Tasks tab -->
                    <richui:tabContent>
                        <br />
                        <br />
                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <label>My Tasks:</label>
                                        </td>
                                        <td valign="top" class="value">
                                            <g:link controller="taskDetailed"
                                                            action="search"
                                                            params="[quickSearch: 'myTodays']">
                                                            Today
                                            </g:link>
                                        </td>
                                    </tr>
            
                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <label>All Tasks:</label>
                                        </td>
                                        <td valign="top" class="value">
                                            <g:link controller="taskDetailed" 
                                                            action="search"
                                                            params="[quickSearch: 'pastWeek']">
                                                            Past Week
                                            </g:link>
                                            <br />
                                            <g:link controller="taskDetailed" 
                                                            action="searchCalendar"
                                                            params="[quickSearch: 'searchPlannersRange']">
                                                            Calendar
                                            </g:link>
                                        </td>
                                    </tr>

<!--                                    More Quick Links:
                                    Open Tasks
                                    Closed Tasks
                                    Tasks I lead.
                                    Week calender
                                    Recent
                                    Today's Entries
                                    My Entries.
                                    Date ranges-->

                                </tbody>
                            </table>
                        </div> <!--End dialog-->
                    </richui:tabContent>
<!-- End Tasks tab -->

<!-- Reports tab -->
                    <richui:tabContent>
                        <br />
                        <br />
                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <label>Frequently Used:</label>
                                        </td>
                                        <td valign="top" class="value">
                                            <g:jasperReport controller="report"
                                                                            action="reactiveRatio"
                                                                            jasper="reactiveRatio"
                                                                            name="Reactive Ratio"
                                                                            format="PDF, XLS">
                                                <richui:dateChooser name="startDate" id="reactiveRatio_startDate" format="dd-MM-yyyy" value="${new Date()-7}" />
                                                to
                                                <richui:dateChooser name="endDate" id="reactiveRatio_endDate" format="dd-MM-yyyy" value="${new Date()}" />
                                            </g:jasperReport>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="immediateCallouts"
                                                                            jasper="immediateCallouts"
                                                                            name="Immediate Callouts"
                                                                            format="PDF, XLS">
                                                <richui:dateChooser name="startDate" id="immediateCallouts_startDate" format="dd-MM-yyyy" value="${new Date()-7}" />
                                                to
                                                <richui:dateChooser name="endDate" id="immediateCallouts_endDate" format="dd-MM-yyyy" value="${new Date()}" />
                                            </g:jasperReport>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="stockTakeOverview"
                                                                            jasper="stockTakeOverview"
                                                                            name="Stock Take (Overview)"
                                                                            format="PDF, XLS">
                                                <g:helpBalloon class="helpballoon" code="report.stock.take.overview" />
                                            </g:jasperReport>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="stockTakeByLocation"
                                                                            jasper="stockTakeByLocation"
                                                                            name="Stock Take (By Location)"
                                                                            format="PDF, XLS">
                                                <g:textField name="locationString" value="e.g: A1%, C55" />
                                                <g:helpBalloon class="helpballoon" code="report.stock.take.by.location" />
                                            </g:jasperReport>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="assetDetail"
                                                                            jasper="assetDetail"
                                                                            name="Asset Detail"
                                                                            format="PDF, XLS">
                                                <g:select optionKey="id"
                                                                    from="${Asset.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }}"
                                                                    name="asset.id"
                                                                    noSelection="['all':/${g.message(code:'default.all.select.text')}/]">
                                                </g:select>
                                            </g:jasperReport>
                                            <g:jasperReport controller="report"
                                                                            action="assetRegister"
                                                                            jasper="assetRegister"
                                                                            name="Asset Register"
                                                                            format="PDF, XLS">
                                                <g:select optionKey="id"
                                                                    from="${Section.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }}"
                                                                    name="section.id"
                                                                    noSelection="['all':/${g.message(code:'default.all.select.text')}/]">
                                                </g:select>
                                            </g:jasperReport>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="templatePortrait"
                                                                            jasper="templatePortrait"
                                                                            name="Template (Portrait)"
                                                                            format="PDF, XLS">
                                                <g:link controller="report" action="downloadTemplate" params="[fileName: 'templatePortrait.jrxml']">
                                                    Download
                                                </g:link>
                                            </g:jasperReport>
                                            <br />
                                            <g:jasperReport controller="report"
                                                                            action="templateLandscape"
                                                                            jasper="templateLandscape"
                                                                            name="Template (Landscape)"
                                                                            format="PDF, XLS">
                                                <g:link controller="report" action="downloadTemplate" params="[fileName: 'templateLandscape.jrxml']">
                                                    Download
                                                </g:link>
                                            </g:jasperReport>
                                            <br />
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div> <!--End dialog-->
                    </richui:tabContent>
<!-- End Reports tab  -->

<!-- Options tab -->
                    <richui:tabContent>
                        <br />
                        <br />
                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <label>Change:</label>
                                        </td>
                                        <td valign="top" class="value">
                                            <a href="${createLink(action:'changePassword')}"> Password</a>
                                            <br />
                                            <a href="${createLink(action:'changeSessionTimeout')}">Session Timeout</a>
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div> <!--End dialog-->
                    </richui:tabContent>
<!-- End Options tab -->

<!-- About tab -->
                    <richui:tabContent>
                        <g:render template="/about" />
                    </richui:tabContent>
<!-- End About tab -->

                </richui:tabContents>
            </richui:tabView>

        </div> <!--End body-->
    </body>
</html>
