

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Task</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Task List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Task</g:link></span>
        </div>
        <div class="body">
            <h1>Edit Task</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${taskInstance?.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetStartDate">Target Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetStartDate','errors')}">
                                    <g:datePicker name="targetStartDate" value="${taskInstance?.targetStartDate}" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'description','errors')}">
                                    <input type="text" maxlength="50" id="description" name="description" value="${fieldValue(bean:taskInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="leadPerson">Lead Person:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'leadPerson','errors')}">
                                    <g:select optionKey="id" from="${Person.list()}" name="leadPerson.id" value="${taskInstance?.leadPerson?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskStatus">Task Status:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskStatus','errors')}">
                                    <g:select optionKey="id" from="${TaskStatus.list()}" name="taskStatus.id" value="${taskInstance?.taskStatus?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="parentTask">Parent Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'parentTask','errors')}">
                                    <g:select optionKey="id" from="${Task.list()}" name="parentTask.id" value="${taskInstance?.parentTask?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:taskInstance, field:'comment')}</textarea>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assignedPersons">Assigned Persons:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'assignedPersons','errors')}">
                                    
<ul>
<g:each var="a" in="${taskInstance?.assignedPersons?}">
    <li><g:link controller="person" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="person" params="['task.id':taskInstance?.id]" action="create">Add Person</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="entries">Entries:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'entries','errors')}">
                                    
<ul>
<g:each var="e" in="${taskInstance?.entries?}">
    <li><g:link controller="entry" action="show" id="${e.id}">${e?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="entry" params="['task.id':taskInstance?.id]" action="create">Add Entry</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${taskInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isApproved">Is Approved:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'isApproved','errors')}">
                                    <g:checkBox name="isApproved" value="${taskInstance?.isApproved}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isScheduled">Is Scheduled:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'isScheduled','errors')}">
                                    <g:checkBox name="isScheduled" value="${taskInstance?.isScheduled}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="modifications">Modifications:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'modifications','errors')}">
                                    
<ul>
<g:each var="m" in="${taskInstance?.modifications?}">
    <li><g:link controller="modification" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="modification" params="['task.id':taskInstance?.id]" action="create">Add Modification</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="subTasks">Sub Tasks:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'subTasks','errors')}">
                                    
<ul>
<g:each var="s" in="${taskInstance?.subTasks?}">
    <li><g:link controller="task" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="task" params="['task.id':taskInstance?.id]" action="create">Add Task</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetCompletionDate">Target Completion Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetCompletionDate','errors')}">
                                    <g:datePicker name="targetCompletionDate" value="${taskInstance?.targetCompletionDate}" ></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskGroup">Task Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskGroup','errors')}">
                                    <g:select optionKey="id" from="${TaskGroup.list()}" name="taskGroup.id" value="${taskInstance?.taskGroup?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
