class  InventoryItem {
    InventoryGroup inventoryGroup
    InventoryType inventoryType
    UnitOfMeasure unitOfMeasure
    InventoryLocation inventoryLocation
    Picture picture
    Supplier preferredSupplier
    String name
    String description = ""
    String comment = ""
    BigDecimal estimatedUnitPriceAmount
    Currency estimatedUnitPriceCurrency
    String suppliersPartNumber
    Integer unitsInStock = 0
    Integer reorderPoint
    Integer reorderQuantity
    boolean isActive = true
    boolean isObsolete = false
    boolean enableReorderListing = true

    static mapping = {
        picture cascade: 'all-delete-orphan', lazy: true, inverse: true
    }

    static hasMany = [spareFor: Asset,
                                    inventoryMovements: InventoryMovement,
                                    alternateSuppliers: Supplier]

//     static belongsTo = []

    static constraints = {
        picture(nullable:true)
        name(unique:true, blank:false, maxSize:50)
        description(maxSize:255)
        comment(maxSize:500)
        unitsInStock(min:0)
        unitOfMeasure()
        estimatedUnitPriceAmount(nullable:true, max: new BigDecimal(1000000000000))
        estimatedUnitPriceCurrency(nullable:true)
        reorderPoint()
        enableReorderListing()
        reorderQuantity(nullable:true)
        isActive()
        isObsolete()
        inventoryGroup()
        inventoryType()
        suppliersPartNumber(blank:true, nullable:true)
        preferredSupplier(nullable:true)
    }

    String toString() {"${this.name}"}

    static searchable = {
        only = ['name', 'description', 'comment', 'isActive', 'isObsolete', 'inventoryLocation', 'inventoryGroup', 'spareFor']
        //name boost: 1.5
        inventoryLocation component: true
        inventoryGroup component: true
        spareFor component: true
    }

}
