
    <div class="dialog">
        <table>
            <tbody>

                <g:if test="${taskInstance.parentTask}">
                    <tr class="prop">
                        <td valign="top" class="name">Parent Task:</td>

                        <td valign="top" class="value">
                            <g:link controller="taskDetailed" action="show" id="${taskInstance.parentTask.id}">
                                ${taskInstance.parentTask.encodeAsHTML()}
                            </g:link>
                        </td>

                    </tr>
                </g:if>

                <tr class="prop">
                    <td valign="top" class="name">Comment:</td>

                    <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'comment')}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Target Start:</td>

                    <td valign="top" class="value">
                        <g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                    </td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Target Completion:</td>

                    <td valign="top" class="value">
                        <g:formatDate date="${taskInstance.targetCompletionDate}" format="EEE, dd-MMM-yyyy"/>
                    </td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">

                        <jsUtil:toggleControl toggleId="modifications"
                                                                imageId="modificationsImg"
                                                                closedImgUrl="${resource(dir:'images/skin',file:'bullet_toggle_plus.png')}"
                                                                openImgUrl="${resource(dir:'images/skin',file:'bullet_toggle_minus.png')}"
                                                                effect="fade"
                                                                text="Modifications"
                                                                />
                    </td>

                    <td  valign="top" style="text-align:left;" class="value">
                        <div id="modifications" style="display:none;">
                            <ul>
                            <g:each var="a" in="${taskModificationList}">
                                <li>${a?.encodeAsHTML()}</li>
                            </g:each>
                            </ul>
                        </div>
                    </td>
                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Primary Asset:</td>

                    <td valign="top" class="value"><g:link controller="assetDetailed" action="show" id="${taskInstance?.primaryAsset?.id}">${taskInstance?.primaryAsset?.encodeAsHTML()}</g:link></td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Associated Assets:</td>

                    <td  valign="top" style="text-align:left;" class="value">
                        <ul>
                        <g:each var="a" in="${taskInstance.associatedAssets}">
                            <li>${a?.encodeAsHTML()}</li>
                        </g:each>
                        </ul>
                    </td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Priority:</td>

                    <td valign="top" class="value">${taskInstance?.taskPriority?.encodeAsHTML()}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Positive Fault:</td>

                    <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'positiveFault')}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Group:</td>

                    <td valign="top" class="value">${taskInstance?.taskGroup?.encodeAsHTML()}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Type:</td>

                    <td valign="top" class="value">${taskInstance?.taskType?.encodeAsHTML()}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Lead Person:</td>

                    <td valign="top" class="value">${taskInstance?.leadPerson?.encodeAsHTML()}</td>

                </tr>

                <tr class="prop">
                    <td valign="top" class="name">Assigned Groups:</td>

                    <td  valign="top" style="text-align:left;" class="value">
                        <ul>
                        <g:each var="a" in="${assignedGroupList}">
                            <li><g:link controller="assignedGroupDetailed" action="edit" id="${a.id}" params="['task.id':taskInstance.id]">${a?.encodeAsHTML()}</g:link></li>
                        </g:each>
                        </ul>
                        <g:link controller="assignedGroupDetailed" action="create" params="['task.id':taskInstance.id]">+Add Group</g:link>
                    </td>

                </tr>


                <tr class="prop">
                    <td valign="top" class="name">Assigned Persons:</td>

                    <td  valign="top" style="text-align:left;" class="value">
                        <ul>
                        <g:each var="a" in="${assignedPersonList}">
                            <li><g:link controller="assignedPersonDetailed" action="edit" id="${a.id}" params="['task.id':taskInstance.id]">${a?.encodeAsHTML()}</g:link></li>
                        </g:each>
                        </ul>
                        <g:link controller="assignedPersonDetailed" action="create" params="['task.id':taskInstance?.id]">+Add Person</g:link>
                    </td>

                </tr>

            </tbody>
        </table>
    </div>

    <div class="buttons">
        <g:form>
            <input type="hidden" name="id" value="${taskInstance?.id}" />

            <g:if test="${taskInstance.trash}" >
                <span class="button"><g:actionSubmit class="restore" onclick="return confirm('Are you sure?');" value="Restore"/></span>
            </g:if>
            <g:else>

                <g:if test="${taskInstance.taskStatus.id != 3}" >

                    <g:if test="${taskInstance.attentionFlag}" >
                        <span class="button"><g:actionSubmit class="flag" value="Clear" action="clearAttentionFlag"/></span>
                    </g:if>
                    <g:else>
                        <span class="button"><g:actionSubmit class="flag" value="Unresolved" action="setAttentionFlag"/></span>
                        <g:helpBalloon class="helpballoon" code="task.status.unresolved" />
                    </g:else>

                    <span class="button">
                        <g:if test="${taskInstance.attentionFlag}" >
                            <g:actionSubmit class="complete"
                                                    value="Resolved"
                                                    onclick="return confirm('${message(code:'task.clear.attention.flag.on.completion.confirm')}');"
                                                    action="complete"/>
                        </g:if>
                        <g:else>
                            <g:actionSubmit class="complete" value="Resolved" action="complete"/>
                        </g:else>
                    </span>
                    <g:helpBalloon class="helpballoon" code="task.status.resolved" />

                    <g:if test="${taskInstance.approved}" >
                        <span class="button"><g:actionSubmit class="renegeApproval" value="Renege Approval" action="renegeApproval" /></span>
                    </g:if>
                    <g:else>
                        <span class="button"><g:actionSubmit class="approve" value="Approve" /></span>
                    </g:else>

                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                    <span class="button">
                        <g:actionSubmit class="trash"
                                                    onclick="return confirm('${message(code:'task.trash.confirm')}');"
                                                    value="Trash" />
                    </span>

                </g:if>
                <g:else>
                    <span class="button"><g:actionSubmit class="reopen" value="Reopen" /></span>
                </g:else>

            </g:else>
        </g:form>
    </div>

    <br />

    <g:if test="${entryFaultList.isEmpty()}">
        <h1>No Faults</h1>
        <br />
    </g:if>
    <g:else>
        <div class="list">
            <h1>Faults</h1>
            <table>
                <thead>
                    <tr>
                        <th>Comment</th>
                        <th>Date</th>
                        <th>Production</th>
                        <th>Down Time</th>
                        <th>Entered By</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <g:each in="${entryFaultList}" status="i" var="entry">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                <td style="width:65%" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    ${entry.comment.encodeAsHTML()}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    <g:formatDate date="${entry.dateDone}" format="EEE, dd-MMM-yyyy"/>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    <g:if test="${entry.productionReference}">
                                        ${entry.productionReference.encodeAsHTML()}
                                    </g:if>
                                    <g:else>
                                        <g:message code="default.none.text" />
                                    </g:else>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    ${entry.durationHour}:${entry.durationMinute}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    ${entry.enteredBy.encodeAsHTML()}
                                </td>

                                <td class="notClickable">
                                    <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" title="Edit" />
                                    </g:link>
                                </td>

                            </tr>
                    </g:each>
                </tbody>
            </table>
        </div>
    </g:else>

    <div class="buttons">
        <g:form controller="entryDetailed">
            <g:hiddenField name="taskInstance.id" value="${taskInstance?.id}" />
            <g:hiddenField name="entryType.id" value="1" />
            <span class="button">
                <g:actionSubmit value="Add Fault" action="create"  class="add"/>
            </span>
        </g:form>
    </div>

    <br />

    <g:if test="${entryCauseList.isEmpty()}">
        <h1>No Causes</h1>
        <br />
    </g:if>
    <g:else>
        <div class="list">
            <h1>Causes</h1>
            <table>
                <thead>
                    <tr>
                        <th>Comment</th>
                        <th>Date Done</th>
                        <th>Entered By</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <g:each in="${entryCauseList}" status="i" var="entry">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                <td style="width:65%" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    ${entry.comment.encodeAsHTML()}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    <g:formatDate date="${entry.dateDone}" format="EEE, dd-MMM-yyyy"/>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    ${entry.enteredBy.encodeAsHTML()}
                                </td>

                                <td class="notClickable">
                                    <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" title="Edit" />
                                    </g:link>
                                </td>

                            </tr>
                    </g:each>
                </tbody>
            </table>
        </div>
    </g:else>

    <div class="buttons">
        <g:form controller="entryDetailed">
            <g:hiddenField name="taskInstance.id" value="${taskInstance?.id}" />
            <g:hiddenField name="entryType.id" value="2" />
            <span class="button">
                <g:actionSubmit value="Add Cause" action="create"  class="add"/>
            </span>
        </g:form>
    </div>

    <br />

    <g:if test="${entryWorkDoneList.isEmpty()}">
        <h1>No Work Done</h1>
        <br />
    </g:if>
    <g:else>
        <div class="list">
            <h1>Work Done</h1>
            <table>
                <thead>
                    <tr>
                        <th>Comment</th>
                        <th>Date Done</th>
                        <th>Duration</th>
                        <th>Entered By</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <g:each in="${entryWorkDoneList}" status="i" var="entry">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                <td width="65%" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    ${entry.comment.encodeAsHTML()}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    <g:formatDate date="${entry.dateDone}" format="EEE, dd-MMM-yyyy"/>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    ${entry.durationHour}:${entry.durationMinute}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                    ${entry.enteredBy.encodeAsHTML()}
                                </td>

                                <td class="notClickable">
                                    <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" title="Edit" />
                                    </g:link>
                                </td>

                            </tr>
                    </g:each>
                </tbody>
            </table>
        </div>
    </g:else>

    <div class="buttons">
        <g:form controller="entryDetailed">
            <g:hiddenField name="taskInstance.id" value="${taskInstance?.id}" />
            <g:hiddenField name="entryType.id" value="3" />
            <span class="button">
                <g:actionSubmit value="Add Work Done" action="create"  class="add"/>
            </span>
        </g:form>
    </div>
