grails.project.class.dir = "target/classes"
grails.project.test.class.dir = "target/test-classes"
grails.project.test.reports.dir = "target/test-reports"

def env = System.getProperty('grails.env')

switch (env) {
    case "production":
        //grails.project.war.file = "target/${appName}-${appVersion}.war"
        grails.project.war.file = "target/${appName}Live.war"
        break
    case "development":
        grails.project.war.file = "target/${appName}Dev.war"
        break
    default:
        grails.project.war.file = "target/${appName}.war"
        break
}

grails.war.resources = { stagingDir, args ->
    // Remove some duplicate/not required jars.
    // From export plugin lib dir.
    delete file: "${stagingDir}/WEB-INF/lib/iText-2.1.5.jar"
    delete file: "${stagingDir}/WEB-INF/lib/xercesImpl.jar"
    // From acegi plugin lib dir.
    delete file: "${stagingDir}/WEB-INF/lib/facebook-java-api-2.0.4.jar"
    delete file: "${stagingDir}/WEB-INF/lib/easymock.jar"
    delete file: "${stagingDir}/WEB-INF/lib/cas-client-core-3.1.1.jar"
    delete file: "${stagingDir}/WEB-INF/lib/openid4java-0.9.2.jar"

}

grails.project.dependency.resolution = {

    // inherit Grails' default dependencies
    inherits("global") {
        // uncomment to disable ehcache
        // excludes 'ehcache'
    }

    log "warn" // log level of Ivy resolver, either 'error', 'warn', 'info', 'debug' or 'verbose'

    repositories {
        grailsHome()
        grailsPlugins()
        grailsCentral()

        // uncomment the below to enable remote dependency resolution
        // from public Maven repositories
        //mavenLocal()
        mavenCentral()
        mavenRepo "https://nexus.codehaus.org/content/repositories/snapshots"
        //mavenRepo "http://snapshots.repository.codehaus.org"
        //mavenRepo "http://repository.codehaus.org"
        //mavenRepo "http://download.java.net/maven/2/"
        //mavenRepo "http://repository.jboss.com/maven2/"
    }

    dependencies {
        // specify dependencies here under either 'build', 'compile', 'runtime', 'test' or 'provided' scopes eg.

        runtime 'mysql:mysql-connector-java:5.1.9'

        // Japser plugin.
        runtime('net.sf.jasperreports:jasperreports:3.7.2') {
            excludes 'antlr', 'commons-beanutils', 'commons-collections', 'commons-logging',
                    'ant', 'mondrian', 'commons-javaflow','barbecue', 'xml-apis-ext','xml-apis', 'xalan', 'groovy-all', 'hibernate', 'saaj-api', 'servlet-api',
                    'xercesImpl','xmlParserAPIs','spring-core','bsh', 'spring-beans', 'jaxen', 'barcode4j','batik-svg-dom','batik-xml','batik-awt-util','batik-dom',
                    'batik-css','batik-gvt','batik-script', 'batik-svggen','batik-util','batik-bridge','persistence-api','jdtcore','bcmail-jdk14','bcprov-jdk14','bctsp-jdk14'
        }
        runtime('org.apache.poi:poi:3.5-FINAL') {
            excludes 'log4j', 'commons-logging'
        }

        runtime('org.apache.ant:ant:1.7.1')
        runtime('org.apache.ant:ant-launcher:1.7.1')

        test("org.seleniumhq.selenium:selenium-htmlunit-driver:latest.release") {
            excludes 'xml-apis'
        }
    }

    plugins {
        test ":geb:0.6-SNAPSHOT"
        test ":spock:0.5-groovy-1.7"
        runtime( ':jasper:1.1.3' ) {
            transitive = false
        }
    }

}
